/*
 * Decompiled with CFR 0.152.
 */
package com.sun.istack.maven;

import com.sun.istack.maven.ArtifactItem;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;

@Mojo(name="metainf-services", defaultPhase=LifecyclePhase.GENERATE_SOURCES, threadSafe=true)
public class MetainfServicesCompilerMojo
extends AbstractMojo {
    private List<ArtifactItem> artifactItems;
    private List<String> providers;
    private File destDir;
    protected ArtifactResolver artifactResolver;
    protected List<RemoteRepository> remoteRepositories;
    private RepositorySystemSession repoSession;
    protected ArtifactRepository localRepository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        this.getLog().info((CharSequence)"About to compile META-INF/services files");
        this.getLog().info((CharSequence)("Artifact Items = " + this.artifactItems));
        this.getLog().info((CharSequence)("SPIs = " + this.providers));
        this.getLog().info((CharSequence)("dest dir = " + this.destDir));
        File msDir = new File(this.destDir, "META-INF/services");
        boolean created = msDir.mkdirs();
        if (!created) {
            Logger.getLogger(MetainfServicesCompilerMojo.class.getName()).log(Level.FINE, "Cannot create directory: {0}", msDir);
        }
        for (String spi : this.providers) {
            PrintWriter registryWriter = null;
            try {
                boolean deleted;
                File spiRegistry = new File(msDir, spi);
                if (spiRegistry.exists() && !(deleted = spiRegistry.delete())) {
                    Logger.getLogger(MetainfServicesCompilerMojo.class.getName()).log(Level.FINE, "Cannot delete file: {0}", spiRegistry);
                }
                if (!(created = spiRegistry.createNewFile())) {
                    Logger.getLogger(MetainfServicesCompilerMojo.class.getName()).log(Level.FINE, "Cannot create file: {0}", spiRegistry);
                }
                registryWriter = new PrintWriter(spiRegistry);
                ZipFile zipFile = null;
                try {
                    BufferedReader reader = null;
                    InputStreamReader isReader = null;
                    for (ArtifactItem ai : this.artifactItems) {
                        DefaultArtifact artifact = new DefaultArtifact(ai.getGroupId(), ai.getArtifactId(), null, ai.getVersion());
                        ArtifactRequest request = new ArtifactRequest();
                        request.setArtifact((Artifact)artifact);
                        request.setRepositories(this.remoteRepositories);
                        this.artifactResolver.resolveArtifact(this.repoSession, request);
                        zipFile = new ZipFile(artifact.getFile());
                        ZipEntry servicesEntry = zipFile.getEntry("META-INF/services/" + spi);
                        if (servicesEntry == null) continue;
                        try {
                            InputStream inputStream = zipFile.getInputStream(servicesEntry);
                            isReader = new InputStreamReader(inputStream);
                            reader = new BufferedReader(isReader);
                            while (reader.ready()) {
                                registryWriter.println(reader.readLine());
                            }
                        }
                        finally {
                            if (reader != null) {
                                reader.close();
                            }
                            if (isReader == null) continue;
                            isReader.close();
                        }
                    }
                }
                catch (ArtifactResolutionException ex) {
                    Logger.getLogger(MetainfServicesCompilerMojo.class.getName()).log(Level.SEVERE, null, ex);
                    throw new MojoExecutionException("Can not resolve artifact!", (Exception)((Object)ex));
                }
                finally {
                    if (zipFile == null) continue;
                    zipFile.close();
                }
            }
            catch (IOException ex) {
                throw new MojoExecutionException("Can not create spi registry file!", (Exception)ex);
            }
            finally {
                if (registryWriter == null) continue;
                registryWriter.close();
            }
        }
    }
}

