/*
 * Decompiled with CFR 0.152.
 */
package com.sun.japex.jdsl.nativecode;

import com.sun.japex.Driver;
import com.sun.japex.Japex;
import com.sun.japex.JapexDriverBase;
import com.sun.japex.TestCase;
import com.sun.japex.TestCaseImpl;
import com.sun.japex.Util;
import java.io.File;

public class JapexNativeDriver
extends JapexDriverBase {
    protected Object _userData = null;

    public void setDriver(Driver driver) {
        super.setDriver(driver);
        String path = driver.getParam("libraryPath");
        String library = driver.getParam("libraryName");
        if (library == null) {
            throw new RuntimeException("JavaNativeDriver requires setting parameter 'libraryName'");
        }
        if (path == null) {
            System.loadLibrary(library);
        } else {
            File file = new File(path + File.separator + System.mapLibraryName(library));
            System.load(file.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        double duration;
        if (Japex.verbose) {
            System.out.println("             " + Thread.currentThread().getName() + " run()");
        }
        TestCaseImpl tc = this._testCase;
        int runIterations = 0;
        if (tc.hasParam("japex.runTime")) {
            duration = this._endTime - Util.currentTimeMillis();
            runIterations = this.runLoopDuration(duration, this._userData);
        } else {
            runIterations = tc.getIntParam("japex.runIterations");
            double startTime = Util.currentTimeMillis();
            this.runLoopIterations(runIterations, this._userData);
            duration = Util.currentTimeMillis() - startTime;
        }
        TestCaseImpl testCaseImpl = tc;
        synchronized (testCaseImpl) {
            long runIterationsSum = tc.hasParam("japex.runIterationsSum") ? tc.getLongParam("japex.runIterationsSum") : 0L;
            tc.setLongParam("japex.runIterationsSum", runIterationsSum + (long)runIterations);
            double runTimeSum = tc.hasParam("japex.runTimeSum") ? tc.getDoubleParam("japex.runTimeSum") : 0.0;
            tc.setDoubleParam("japex.runTimeSum", runTimeSum + duration);
        }
        if (Japex.verbose) {
            System.out.println("               " + Thread.currentThread().getName() + " japex.actualRunIterations = " + runIterations);
            System.out.println("               " + Thread.currentThread().getName() + " japex.actualRunTime (ms) = " + duration);
        }
    }

    public void initializeDriver() {
        this._userData = this.initializeDriver(this._userData);
    }

    public native Object initializeDriver(Object var1);

    public void prepare(TestCase testCase) {
        this.prepare(testCase, this._userData);
    }

    public native void prepare(TestCase var1, Object var2);

    public void warmup(TestCase testCase) {
        this.warmup(testCase, this._userData);
    }

    public native void warmup(TestCase var1, Object var2);

    public void run(TestCase testCase) {
        this.run(testCase, this._userData);
    }

    public native void run(TestCase var1, Object var2);

    public void finish(TestCase testCase) {
        this.finish(testCase, this._userData);
    }

    public native void finish(TestCase var1, Object var2);

    public void terminateDriver() {
        this.terminateDriver(this._userData);
    }

    public native void terminateDriver(Object var1);

    public native int runLoopDuration(double var1, Object var3);

    public native void runLoopIterations(int var1, Object var2);
}

