/*
 * Decompiled with CFR 0.152.
 */
package com.sun.japex.jdsl.xml;

import com.sun.japex.JapexDriverBase;
import com.sun.japex.Params;
import com.sun.japex.TestCase;
import com.sun.japex.Util;
import com.sun.japex.jdsl.xml.FastInfosetParamSetter;
import com.sun.japex.jdsl.xml.FastInfosetParserDriver;
import com.sun.japex.jdsl.xml.TestCaseUtil;
import com.sun.xml.fastinfoset.sax.SAXDocumentSerializer;
import com.sun.xml.fastinfoset.tools.VocabularyGenerator;
import com.sun.xml.fastinfoset.vocab.ParserVocabulary;
import com.sun.xml.fastinfoset.vocab.SerializerVocabulary;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jvnet.fastinfoset.FastInfosetParser;
import org.jvnet.fastinfoset.FastInfosetSerializer;
import org.w3c.dom.Document;
import org.xml.sax.helpers.DefaultHandler;

public abstract class BaseParserDriver
extends JapexDriverBase {
    public static final String TESTCASE_NORMALIZE = "normalizeTestCaseData";
    protected SAXDocumentSerializer _saxSerializer = null;
    protected ByteArrayInputStream _inputStream;
    protected ByteArrayOutputStream _outputStream;
    protected SerializerVocabulary _initialVocabulary;
    protected HashMap<String, ParserVocabulary> _externalVocabularyMap;
    protected DocumentBuilder _builder;
    protected String _xmlFile;

    public void prepare(TestCase testCase) {
        this._xmlFile = TestCaseUtil.getXmlFile(testCase);
        try {
            FileInputStream fis = new FileInputStream(new File(this._xmlFile));
            this._outputStream = new ByteArrayOutputStream();
            if (this instanceof FastInfosetParserDriver) {
                ByteArrayInputStream bais = new ByteArrayInputStream(Util.streamToByteArray((InputStream)fis));
                this.prepareFI(bais, this._xmlFile);
            } else {
                BufferedInputStream bis = new BufferedInputStream(fis);
                this.prepareXML(bis);
            }
            fis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public void prepareXML(InputStream in) throws Exception {
        byte[] xmlFileByteArray = Util.streamToByteArray((InputStream)in);
        this._inputStream = new ByteArrayInputStream(xmlFileByteArray);
    }

    public void prepareFI(ByteArrayInputStream in, String name) throws Exception {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        SAXParser parser = spf.newSAXParser();
        this._saxSerializer = new SAXDocumentSerializer();
        FastInfosetParamSetter.setParams((FastInfosetSerializer)this._saxSerializer, (Params)this);
        this._saxSerializer.setOutputStream((OutputStream)this._outputStream);
        if (this.getBooleanParam("jdsl.externalVocabulary")) {
            SerializerVocabulary externalSerializeVocabulary = new SerializerVocabulary();
            ParserVocabulary externalParserVocabulary = new ParserVocabulary();
            VocabularyGenerator vocabularyGenerator = new VocabularyGenerator(externalSerializeVocabulary, externalParserVocabulary);
            vocabularyGenerator.setCharacterContentChunkSizeLimit(0);
            vocabularyGenerator.setAttributeValueSizeLimit(0);
            parser.parse((InputStream)in, (DefaultHandler)vocabularyGenerator);
            in.reset();
            String externalVocabularyURI = "file:///" + name;
            this._initialVocabulary = new SerializerVocabulary();
            this._initialVocabulary.setExternalVocabulary(externalVocabularyURI, externalSerializeVocabulary, false);
            this._saxSerializer.setVocabulary(this._initialVocabulary);
            FastInfosetParser fps = ((FastInfosetParserDriver)((Object)this)).getParser();
            this._externalVocabularyMap = new HashMap();
            this._externalVocabularyMap.put(externalVocabularyURI, externalParserVocabulary);
            fps.setExternalVocabularies(this._externalVocabularyMap);
        }
        parser.setProperty("http://xml.org/sax/properties/lexical-handler", this._saxSerializer);
        parser.parse((InputStream)in, (DefaultHandler)this._saxSerializer);
        this._inputStream = new ByteArrayInputStream(this._outputStream.toByteArray());
    }

    public Document createDocument() throws Exception {
        DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
        builderFactory.setNamespaceAware(true);
        this._builder = builderFactory.newDocumentBuilder();
        Document d = this._builder.parse(this._inputStream);
        this._inputStream.reset();
        return d;
    }

    public void finish(TestCase testCase) {
        super.finish(testCase);
        this._inputStream.reset();
        if (!this.getBooleanParam("jdsl.doNotReportSize")) {
            testCase.setDoubleParam("japex.resultValueX", (double)this._inputStream.available() / 1024.0);
            this.getTestSuite().setParam("japex.resultUnitX", "KBytes");
        }
    }
}

