/*
 * Decompiled with CFR 0.152.
 */
package com.sun.japex.jdsl.xml;

import com.sun.japex.TestCase;
import com.sun.japex.jdsl.xml.ByteStreamDriver;
import com.sun.xml.fastinfoset.DecoderStateTables;

public class UTF8StreamDriver
extends ByteStreamDriver {
    protected char[] _charBuffer;

    public UTF8StreamDriver() {
        this._charBuffer = new char[this._buffer.length];
    }

    public void run(TestCase testCase) {
        int bytesRead;
        int offset = 0;
        this._inputStream.reset();
        while ((bytesRead = this._inputStream.read(this._buffer, offset, this._buffer.length - offset)) > 0) {
            int left = this.decodeUTF8ByteBuffer(this._buffer, bytesRead, this._charBuffer);
            for (int i = 0; i < left; ++i) {
                this._buffer[i] = this._buffer[bytesRead - left + i];
            }
            offset = left;
        }
    }

    int decodeUTF8ByteBuffer(byte[] buffer, int bytes, char[] charBuffer) {
        int j = 0;
        block6: for (int i = 0; i < bytes; ++i) {
            byte b1 = buffer[i];
            switch (DecoderStateTables.UTF8((int)b1)) {
                case 1: {
                    charBuffer[j++] = (char)b1;
                    continue block6;
                }
                case 2: {
                    int b2;
                    if (i + 1 >= bytes) {
                        return 1;
                    }
                    if (((b2 = buffer[i++] & 0xFF) & 0xC0) != 128) {
                        throw new RuntimeException("Illegal 2-char UTF-8 sequence");
                    }
                    charBuffer[j++] = (char)((b1 & 0x1F) << 6 | b2 & 0x3F);
                    continue block6;
                }
                case 3: {
                    int b3;
                    int b2;
                    if (i + 2 >= bytes) {
                        return 2;
                    }
                    if (((b2 = buffer[i++] & 0xFF) & 0xC0) != 128 || b1 == 237 && b2 >= 160 || (b1 & 0xF) == 0 && (b2 & 0x20) == 0) {
                        throw new RuntimeException("Illegal 3-char UTF-8 sequence");
                    }
                    if (((b3 = buffer[i++] & 0xFF) & 0xC0) != 128) {
                        throw new RuntimeException("Illegal 3-char UTF-8 sequence");
                    }
                    return (char)((b1 & 0xF) << 12 | (b2 & 0x3F) << 6 | b3 & 0x3F);
                }
                case 4: {
                    throw new RuntimeException("High/low surrogates not supported");
                }
                default: {
                    throw new RuntimeException("Error decoding UTF-8 char stream");
                }
            }
        }
        return 0;
    }
}

