/*
 * Decompiled with CFR 0.152.
 */
package com.sun.japex.jdsl.xml;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class XMLStreamReaderToXMLStreamWriter {
    protected XMLStreamReader in;
    protected XMLStreamWriter out;

    public void bridge(XMLStreamReader in, XMLStreamWriter out) throws XMLStreamException {
        assert (in != null && out != null);
        this.in = in;
        this.out = out;
        int depth = 0;
        int event = in.getEventType();
        if (event == 7) {
            while (!in.isStartElement()) {
                event = in.next();
            }
        }
        if (event != 1) {
            throw new IllegalStateException("The current event is not START_ELEMENT\n but " + event);
        }
        do {
            switch (event) {
                case 1: {
                    ++depth;
                    this.handleStartElement();
                    break;
                }
                case 2: {
                    this.handleEndElement();
                    if (--depth != 0) break;
                    return;
                }
                case 4: {
                    this.handleCharacters();
                    break;
                }
                case 9: {
                    this.handleEntityReference();
                    break;
                }
                case 3: {
                    this.handlePI();
                    break;
                }
                case 5: {
                    this.handleComment();
                    break;
                }
                case 11: {
                    this.handleDTD();
                    break;
                }
                case 12: {
                    this.handleCDATA();
                    break;
                }
                case 6: {
                    this.handleSpace();
                    break;
                }
                default: {
                    throw new InternalError("processing event: " + event);
                }
            }
            event = in.next();
        } while (depth != 0);
    }

    protected void handlePI() throws XMLStreamException {
        this.out.writeProcessingInstruction(this.in.getPITarget(), this.in.getPIData());
    }

    protected void handleCharacters() throws XMLStreamException {
        this.out.writeCharacters(this.in.getTextCharacters(), this.in.getTextStart(), this.in.getTextLength());
    }

    protected void handleEndElement() throws XMLStreamException {
        this.out.writeEndElement();
    }

    protected void handleStartElement() throws XMLStreamException {
        String nsUri = this.in.getNamespaceURI();
        if (nsUri == null) {
            this.out.writeStartElement(this.in.getLocalName());
        } else {
            this.out.writeStartElement(this.in.getPrefix(), this.in.getLocalName(), nsUri);
        }
        int nsCount = this.in.getNamespaceCount();
        for (int i = 0; i < nsCount; ++i) {
            this.out.writeNamespace(this.in.getNamespacePrefix(i), this.in.getNamespaceURI(i));
        }
        int attCount = this.in.getAttributeCount();
        for (int i = 0; i < attCount; ++i) {
            this.handleAttribute(i);
        }
    }

    protected void handleAttribute(int i) throws XMLStreamException {
        String nsUri = this.in.getAttributeNamespace(i);
        if (nsUri == null) {
            this.out.writeAttribute(this.in.getAttributeLocalName(i), this.in.getAttributeValue(i));
        } else {
            this.out.writeAttribute(this.in.getAttributePrefix(i), nsUri, this.in.getAttributeLocalName(i), this.in.getAttributeValue(i));
        }
    }

    protected void handleDTD() throws XMLStreamException {
        this.out.writeDTD(this.in.getText());
    }

    protected void handleComment() throws XMLStreamException {
        this.out.writeComment(this.in.getText());
    }

    protected void handleEntityReference() throws XMLStreamException {
        this.out.writeEntityRef(this.in.getText());
    }

    protected void handleSpace() throws XMLStreamException {
        this.handleCharacters();
    }

    protected void handleCDATA() throws XMLStreamException {
        this.out.writeCData(this.in.getText());
    }
}

