/*
 * Decompiled with CFR 0.152.
 */
package com.sun.japex.jdsl.xml.size;

import com.sun.japex.JapexDriverBase;
import com.sun.japex.TestCase;
import com.sun.japex.Util;
import com.sun.japex.jdsl.xml.TestCaseUtil;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.SAXException;

public abstract class BaseSizeDriver
extends JapexDriverBase {
    protected byte[] _content;

    protected SAXParser createSAXParser() throws ParserConfigurationException, SAXException {
        SAXParserFactory spf = SAXParserFactory.newInstance();
        spf.setNamespaceAware(true);
        return spf.newSAXParser();
    }

    protected InputStream getInputStream(String fileName) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(fileName));
    }

    protected byte[] getBytesFromInputStream(InputStream in) {
        return Util.streamToByteArray((InputStream)in);
    }

    public void finish(TestCase testCase) {
        String xmlFile = TestCaseUtil.getXmlFile(testCase);
        try {
            this.serialize(this.getInputStream(xmlFile), xmlFile);
            if (this.getBooleanParam("jdsl.GZIP")) {
                ByteArrayOutputStream gzipBaos = new ByteArrayOutputStream();
                GZIPOutputStream gzipOs = new GZIPOutputStream(gzipBaos);
                gzipOs.write(this._content, 0, this._content.length);
                gzipOs.finish();
                this._content = gzipBaos.toByteArray();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        testCase.setDoubleParam("japex.resultValue", (double)this._content.length / 1024.0);
    }

    protected abstract void serialize(InputStream var1, String var2) throws Exception;
}

