/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.freemarker;

import com.sun.jersey.api.container.ContainerException;
import com.sun.jersey.api.core.ResourceConfig;
import com.sun.jersey.api.view.Viewable;
import com.sun.jersey.spi.template.ViewProcessor;
import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;

public class FreemarkerViewProcessor
implements ViewProcessor<String> {
    public static final String FREEMARKER_TEMPLATES_BASE_PATH = "com.sun.jersey.freemarker.templateBasePath";
    private final Configuration configuration = new Configuration();
    @Context
    private UriInfo uriInfo;
    private String basePath;

    public FreemarkerViewProcessor(@Context ResourceConfig resourceConfig) {
        this.configuration.setObjectWrapper((ObjectWrapper)new DefaultObjectWrapper());
        String path = (String)resourceConfig.getProperties().get(FREEMARKER_TEMPLATES_BASE_PATH);
        this.basePath = path == null ? "" : (path.charAt(0) == '/' ? path : "/" + path);
    }

    public String resolve(String path) {
        if (this.basePath != "") {
            path = this.basePath + path;
        }
        if (this.uriInfo.getMatchedResources().get(0).getClass().getResource(path) != null) {
            return path;
        }
        if (!path.endsWith(".ftl")) {
            path = path + ".ftl";
            if (this.uriInfo.getMatchedResources().get(0).getClass().getResource(path) != null) {
                return path;
            }
        }
        return null;
    }

    public void writeTo(String resolvedPath, Viewable viewable, OutputStream out) throws IOException {
        out.flush();
        this.configuration.setClassForTemplateLoading(this.uriInfo.getMatchedResources().get(0).getClass(), "/");
        Template template = this.configuration.getTemplate(resolvedPath);
        try {
            template.process(viewable.getModel(), (Writer)new OutputStreamWriter(out));
        }
        catch (TemplateException te) {
            throw new ContainerException((Throwable)te);
        }
    }
}

