/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.moxy;

import com.sun.jersey.core.util.FeaturesAndProperties;
import com.sun.jersey.moxy.Helper;
import com.sun.jersey.spi.MessageBodyWorkers;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import javax.xml.bind.annotation.XmlRootElement;

@Provider
public class MoxyMessageBodyWorker
implements MessageBodyWriter,
MessageBodyReader {
    final MessageBodyWorkers msgBodyWorkers;
    final Set<String> moxyPackageNames = new HashSet<String>();
    private static final JaxbDollType JaxbDoll = new JaxbDollType();

    public MoxyMessageBodyWorker(@Context MessageBodyWorkers mbw, @Context FeaturesAndProperties fap) {
        this.msgBodyWorkers = mbw;
        this.moxyPackageNames.addAll(MoxyMessageBodyWorker.getPackageNames(fap.getProperty("com.sun.jersey.moxy.config.property.packages")));
    }

    Class getJAXBDollClass() {
        return JaxbDoll.getClass();
    }

    static List<String> getPackageNames(Object p) {
        if (p == null) {
            return Collections.EMPTY_LIST;
        }
        if (p instanceof String) {
            return Arrays.asList(Helper.getElements(new String[]{(String)p}));
        }
        if (p instanceof String[]) {
            return Arrays.asList(Helper.getElements((String[])p));
        }
        throw new IllegalArgumentException("com.sun.jersey.moxy.config.property.packages must have a property value of type String or String[]");
    }

    public boolean isWriteable(Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.typeIsKnown(type) && this.mediaTypeIsXml(mediaType);
    }

    boolean typeIsKnown(Class type) {
        Package typePackage = type.getPackage();
        return typePackage != null && this.moxyPackageNames.contains(typePackage.getName());
    }

    boolean mediaTypeIsXml(MediaType mediaType) {
        String subtype = mediaType.getSubtype();
        if (subtype == null) {
            return false;
        }
        return "xml".equals(subtype) || subtype.endsWith("+xml");
    }

    public long getSize(Object t, Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(Object t, Class type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        this.lookupXmlWriter(this.msgBodyWorkers, mediaType).writeTo(t, type, genericType, annotations, mediaType, httpHeaders, entityStream);
    }

    public boolean isReadable(Class type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.typeIsKnown(type) && this.mediaTypeIsXml(mediaType);
    }

    public Object readFrom(Class type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        return this.lookupXmlReader(this.msgBodyWorkers, mediaType).readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream);
    }

    MessageBodyWriter lookupXmlWriter(MessageBodyWorkers mbw, MediaType mt) {
        for (MessageBodyWriter writer : (List)mbw.getWriters(mt).get(mt)) {
            if (writer instanceof MoxyMessageBodyWorker || !writer.isWriteable(this.getJAXBDollClass(), (Type)this.getJAXBDollClass(), null, mt)) continue;
            return writer;
        }
        return null;
    }

    MessageBodyReader lookupXmlReader(MessageBodyWorkers mbw, MediaType mt) {
        for (MessageBodyReader reader : (List)mbw.getReaders(mt).get(mt)) {
            if (reader instanceof MoxyMessageBodyWorker || !reader.isReadable(this.getJAXBDollClass(), (Type)this.getJAXBDollClass(), null, mt)) continue;
            return reader;
        }
        return null;
    }

    @XmlRootElement
    public static class JaxbDollType {
    }
}

