/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.multipart;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class BodyPartEntity {
    private static final int DEFAULT_THRESHOLD = 4096;
    private byte[] data = null;
    private File file = null;
    private InputStream istream = null;
    private int threshold = 0;

    public BodyPartEntity(InputStream stream) throws IOException {
        this(stream, 4096);
    }

    public BodyPartEntity(InputStream stream, int threshold) throws IOException {
        if (threshold <= 0) {
            throw new IllegalArgumentException("Invalid threshold value " + threshold);
        }
        this.threshold = threshold;
        byte[] buffer = new byte[threshold];
        int n = stream.read(buffer);
        if (n < threshold) {
            this.data = new byte[n];
            System.arraycopy(buffer, 0, this.data, 0, n);
        } else {
            this.file = File.createTempFile("BodyPartEntity.", ".data");
            BufferedOutputStream ostream = new BufferedOutputStream(new FileOutputStream(this.file), threshold);
            ((OutputStream)ostream).write(buffer, 0, n);
            while ((n = stream.read(buffer)) > 0) {
                ((OutputStream)ostream).write(buffer, 0, n);
            }
            ((OutputStream)ostream).close();
        }
    }

    public void cleanup() {
        if (this.istream != null) {
            try {
                this.istream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.istream = null;
        if (this.file != null && this.file.exists()) {
            this.file.delete();
        }
    }

    public InputStream getInputStream() throws IOException {
        this.istream = this.data != null ? new ByteArrayInputStream(this.data) : new BufferedInputStream(new FileInputStream(this.file), this.threshold);
        return this.istream;
    }
}

