/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.multipart.impl;

import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.BodyPartEntity;
import com.sun.jersey.multipart.MultiPart;
import com.sun.jersey.multipart.MultiPartConfig;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMultipart;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Providers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Consumes(value={"multipart/*"})
public class MultiPartReader
implements MessageBodyReader<MultiPart> {
    private MultiPartConfig config = null;
    @Context
    private Providers providers;

    public MultiPartReader(@Context MultiPartConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("The MultiPartConfig instance we expected is not present.  Have you registered the MultiPartConfigProvider class?");
        }
        this.config = config;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return MultiPart.class.isAssignableFrom(type);
    }

    public MultiPart readFrom(Class<MultiPart> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, InputStream stream) throws IOException, WebApplicationException {
        MimeMultipart mm = null;
        try {
            mm = new MimeMultipart((DataSource)new MultiPartDataSource(mediaType.toString(), stream));
        }
        catch (MessagingException ex) {
            throw new WebApplicationException((Throwable)ex);
        }
        MultiPart multiPart = new MultiPart();
        multiPart.setProviders(this.providers);
        MultivaluedMap<String, String> mpHeaders = multiPart.getHeaders();
        for (Map.Entry entry : headers.entrySet()) {
            List values = (List)entry.getValue();
            for (String value : values) {
                mpHeaders.add(entry.getKey(), (Object)value);
            }
        }
        multiPart.setMediaType(mediaType);
        try {
            int count = mm.getCount();
            for (int i = 0; i < count; ++i) {
                javax.mail.BodyPart bp = mm.getBodyPart(i);
                BodyPart bodyPart = new BodyPart();
                bodyPart.setProviders(this.providers);
                Enumeration bpHeaders = bp.getAllHeaders();
                while (bpHeaders.hasMoreElements()) {
                    Header bpHeader = (Header)bpHeaders.nextElement();
                    bodyPart.getHeaders().add((Object)bpHeader.getName(), (Object)bpHeader.getValue());
                }
                MediaType bpMediaType = MediaType.valueOf((String)bp.getContentType());
                bodyPart.setMediaType(bpMediaType);
                bodyPart.setEntity(new BodyPartEntity(bp.getInputStream(), this.config.getBufferThreshold()));
                multiPart.getBodyParts().add(bodyPart);
            }
        }
        catch (MessagingException ex) {
            throw new WebApplicationException((Throwable)ex);
        }
        return multiPart;
    }

    private class MultiPartDataSource
    implements DataSource {
        private String contentType;
        private InputStream stream;

        public MultiPartDataSource(String contentType, InputStream stream) {
            this.contentType = contentType;
            this.stream = stream;
        }

        public String getContentType() {
            return this.contentType;
        }

        public InputStream getInputStream() throws IOException {
            return this.stream;
        }

        public String getName() {
            throw new UnsupportedOperationException("getName() is not supported.");
        }

        public OutputStream getOutputStream() throws IOException {
            throw new UnsupportedOperationException("getOutputStream() is not supported");
        }
    }
}

