/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.server.impl.wadl;

import com.sun.jersey.server.wadl.ApplicationDescription;
import com.sun.jersey.server.wadl.WadlApplicationContext;
import com.sun.jersey.spi.resource.Singleton;
import com.sun.research.ws.wadl.Application;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.Marshaller;

@Singleton
public final class WadlResource {
    public static final String HTTPDATEFORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final Logger LOGGER = Logger.getLogger(WadlResource.class.getName());
    private WadlApplicationContext wadlContext;
    private URI lastBaseUri;
    private byte[] wadlXmlRepresentation;
    private String lastModified;

    public WadlResource(@Context WadlApplicationContext wadlContext) {
        this.wadlContext = wadlContext;
        this.lastModified = new SimpleDateFormat(HTTPDATEFORMAT).format(new Date());
    }

    @Produces(value={"application/vnd.sun.wadl+xml", "application/xml"})
    @GET
    public synchronized Response getWadl(@Context UriInfo uriInfo) {
        if (!this.wadlContext.isWadlGenerationEnabled()) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        if (this.wadlXmlRepresentation == null || this.lastBaseUri != null && !this.lastBaseUri.equals(uriInfo.getBaseUri())) {
            this.lastBaseUri = uriInfo.getBaseUri();
            this.lastModified = new SimpleDateFormat(HTTPDATEFORMAT).format(new Date());
            ApplicationDescription applicationDescription = this.wadlContext.getApplication(uriInfo);
            Application application = applicationDescription.getApplication();
            try {
                Marshaller marshaller = this.wadlContext.getJAXBContext().createMarshaller();
                marshaller.setProperty("jaxb.formatted.output", (Object)true);
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                marshaller.marshal((Object)application, (OutputStream)os);
                this.wadlXmlRepresentation = os.toByteArray();
                os.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Could not marshal wadl Application.", e);
                return Response.ok(applicationDescription).build();
            }
        }
        return Response.ok(new ByteArrayInputStream(this.wadlXmlRepresentation)).header("Last-modified", this.lastModified).build();
    }

    @Produces(value={"application/xml"})
    @GET
    @Path(value="{path}")
    public synchronized Response geExternalGramar(@Context UriInfo uriInfo, @PathParam(value="path") String path) {
        if (!this.wadlContext.isWadlGenerationEnabled()) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        ApplicationDescription applicationDescription = this.wadlContext.getApplication(uriInfo);
        ApplicationDescription.ExternalGrammar externalMetadata = applicationDescription.getExternalGrammar(path);
        if (externalMetadata == null) {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
        return Response.ok().type(externalMetadata.getType()).entity(externalMetadata.getContent()).build();
    }
}

