/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.impl.client.urlconnection;

import com.sun.jersey.api.InBoundHeaders;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.spi.MessageBodyWorkers;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.ProtocolException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.RuntimeDelegate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class URLConnectionClientHandler
implements ClientHandler {
    private static final Annotation[] EMPTY_ANNOTATIONS = new Annotation[0];
    @Context
    private MessageBodyWorkers bodyContext;

    @Override
    public ClientResponse handle(ClientRequest ro) {
        try {
            return this._invoke(ro);
        }
        catch (Exception ex) {
            throw new ClientHandlerException(ex);
        }
    }

    private ClientResponse _invoke(ClientRequest ro) throws ProtocolException, IOException {
        Boolean followRedirects;
        Integer connectTimeout;
        HttpURLConnection uc = (HttpURLConnection)ro.getURI().toURL().openConnection();
        Integer readTimeout = (Integer)ro.getProperties().get("com.sun.jersey.client.property.readTimeout");
        if (readTimeout != null) {
            uc.setReadTimeout(readTimeout);
        }
        if ((connectTimeout = (Integer)ro.getProperties().get("com.sun.jersey.client.property.connectTimeout")) != null) {
            uc.setConnectTimeout(connectTimeout);
        }
        if ((followRedirects = (Boolean)ro.getProperties().get("com.sun.jersey.client.property.followRedirects")) != null) {
            uc.setInstanceFollowRedirects(followRedirects);
        }
        uc.setRequestMethod(ro.getMethod());
        this.writeHeaders(ro.getMetadata(), uc);
        Object entity = ro.getEntity();
        if (entity != null) {
            uc.setDoOutput(true);
            this.writeEntity(uc, ro, entity);
        }
        return new URLConnectionResponse(ro.getMethod(), uc.getResponseCode(), uc);
    }

    private void writeHeaders(MultivaluedMap<String, Object> metadata, HttpURLConnection uc) {
        for (Map.Entry e : metadata.entrySet()) {
            List vs = (List)e.getValue();
            if (vs.size() == 1) {
                uc.setRequestProperty((String)e.getKey(), this.getHeaderValue(vs.get(0)));
                continue;
            }
            StringBuilder b = new StringBuilder();
            boolean add = false;
            for (Object v : (List)e.getValue()) {
                if (add) {
                    b.append(',');
                }
                add = true;
                b.append(this.getHeaderValue(v));
            }
            uc.setRequestProperty((String)e.getKey(), b.toString());
        }
    }

    private String getHeaderValue(Object headerValue) {
        RuntimeDelegate.HeaderDelegate hp = RuntimeDelegate.getInstance().createHeaderDelegate(headerValue.getClass());
        return hp.toString(headerValue);
    }

    private void writeEntity(HttpURLConnection uc, ClientRequest ro, Object entity) throws IOException {
        MultivaluedMap<String, Object> metadata = ro.getMetadata();
        MediaType mediaType = null;
        Object mediaTypeHeader = metadata.getFirst((Object)"Content-Type");
        mediaType = mediaTypeHeader instanceof MediaType ? (MediaType)mediaTypeHeader : (mediaTypeHeader != null ? MediaType.valueOf((String)mediaTypeHeader.toString()) : new MediaType("application", "octet-stream"));
        Type entityType = null;
        if (entity instanceof GenericEntity) {
            GenericEntity ge = (GenericEntity)entity;
            entityType = ge.getType();
            entity = ge.getEntity();
        } else {
            entityType = entity.getClass();
        }
        Class<?> entityClass = entity.getClass();
        MessageBodyWriter bw = this.bodyContext.getMessageBodyWriter(entityClass, entityType, EMPTY_ANNOTATIONS, mediaType);
        if (bw == null) {
            throw new ClientHandlerException("A message body writer for Java type, " + entity.getClass() + ", and MIME media type, " + mediaType + ", was not found");
        }
        long size = bw.getSize(entity, entityClass, entityType, EMPTY_ANNOTATIONS, mediaType);
        if (size != -1L && size < Integer.MAX_VALUE) {
            uc.setFixedLengthStreamingMode((int)size);
        } else {
            Integer chunkedEncodingSize = (Integer)ro.getProperties().get("com.sun.jersey.client.property.chunkedEncodingSize");
            if (chunkedEncodingSize != null) {
                uc.setChunkedStreamingMode(chunkedEncodingSize);
            }
        }
        OutputStream out = ro.getAdapter().adapt(ro, uc.getOutputStream());
        bw.writeTo(entity, entityClass, entityType, EMPTY_ANNOTATIONS, mediaType, metadata, out);
        out.flush();
        out.close();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class URLConnectionResponse
    extends ClientResponse {
        private Map<String, Object> properties;
        private final String method;
        private int status;
        private final HttpURLConnection uc;
        private final MultivaluedMap<String, String> metadata;
        private InputStream in;

        URLConnectionResponse(String method, int status, HttpURLConnection uc) {
            this.method = method;
            this.status = status;
            this.uc = uc;
            this.metadata = new InBoundHeaders();
            for (Map.Entry<String, List<String>> e : uc.getHeaderFields().entrySet()) {
                if (e.getKey() == null) continue;
                this.metadata.put((Object)e.getKey(), e.getValue());
            }
            try {
                this.in = this.getInputStream();
            }
            catch (IOException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        @Override
        public int getStatus() {
            return this.status;
        }

        @Override
        public void setStatus(int status) {
            this.status = status;
        }

        @Override
        public Response.Status getResponseStatus() {
            return Response.Status.fromStatusCode((int)this.status);
        }

        @Override
        public void setResponseStatus(Response.Status status) {
            this.setStatus(status.getStatusCode());
        }

        @Override
        public MultivaluedMap<String, String> getMetadata() {
            return this.metadata;
        }

        @Override
        public boolean hasEntity() {
            if (this.method.equals("HEAD") || this.in == null) {
                return false;
            }
            int l = this.uc.getContentLength();
            return l > 0 || l == -1;
        }

        @Override
        public InputStream getEntityInputStream() {
            return this.in;
        }

        @Override
        public void setEntityInputStream(InputStream in) {
            this.in = in;
        }

        @Override
        public <T> T getEntity(Class<T> c) {
            return this.getEntity(c, c);
        }

        @Override
        public <T> T getEntity(GenericType<T> gt) {
            return this.getEntity(gt.getRawClass(), gt.getType());
        }

        private <T> T getEntity(Class<T> c, Type type) {
            try {
                MediaType mediaType = this.getType();
                MessageBodyReader br = URLConnectionClientHandler.this.bodyContext.getMessageBodyReader(c, type, EMPTY_ANNOTATIONS, mediaType);
                if (br == null) {
                    throw new ClientHandlerException("A message body reader for Java type, " + c + ", and MIME media type, " + mediaType + ", was not found");
                }
                Object t = br.readFrom(c, type, EMPTY_ANNOTATIONS, mediaType, this.metadata, this.in);
                if (!(t instanceof InputStream)) {
                    this.in.close();
                }
                this.in = null;
                return (T)t;
            }
            catch (IOException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        @Override
        public Map<String, Object> getProperties() {
            if (this.properties != null) {
                return this.properties;
            }
            this.properties = new HashMap<String, Object>();
            return this.properties;
        }

        private InputStream getInputStream() throws IOException {
            if (this.status < 300) {
                return this.uc.getInputStream();
            }
            InputStream ein = this.uc.getErrorStream();
            return ein != null ? ein : new ByteArrayInputStream(new byte[0]);
        }
    }
}

