/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2011 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * http://glassfish.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.jersey.spi.monitoring;

import com.sun.jersey.api.model.AbstractResourceMethod;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * Provider for "monitoring" calls.
 * <p/>
 * Methods are called right before some event happens, statistics are not generated by
 * default, you have to register {@link MonitoringProvider} via {@link MonitoringProviderAdapter}
 * and compute them by yourself. Id parameter is context ID, which is equal for events
 * generated from processing single request (starts with requestStart and ends with
 * requestEnd). Context IDs might be reused.
 * <p/>
 * RequestStart and requestEnd are called during processing every request. Other methods
 * might not be called, for example resource method might not be found.
 * <p/>
 * Metrics examples:
 * <p/>
 * Total Invocation count
 * - count number of requestStart calls
 * <p/>
 * Average Invocation Count
 * - Total invocation count / server uptime
 * <p/>
 * Last Invoke Clock Time
 * - remember when requestStart was called
 * <p/>
 * Total Execution Time
 * - ? what exactly is this supposed to mean ?
 * - remember time period between reqestStart and requestEnd call
 * (and add it to some total sum)
 * <p/>
 * Average Time per invoke
 * - Total Execution Time / Total Invocation count?
 * <p/>
 * Execution Time Low
 * - shortest invocation time
 * <p/>
 * Execution Time High
 * - longest invocation time
 * <p/>
 * Total Error Count
 * -  count number of requestEnd calls
 * <p/>
 * Average Error Count per Period
 * - Total Error Count / Period
 * <p/>
 * Last Error Detail
 * - remember last Exception from requestEnd call
 * <p/>
 * Last Error Clock Time
 * - remember when error(Exception ex) was called
 *
 * @author Jakub.Podlesak@Oracle.Com
 */
public interface MonitoringProvider {

    /**
     * Called when Jersey receives request from lower layer.
     *
     * @param id      Context ID.
     * @param request request instance. It MUST NOT be modified.
     */
    public void requestStart(long id, HttpServletRequest request);

    /**
     * Called when Jersey finds suitable sub resource which will
     * be used during request processing.
     *
     * @param id          Context ID.
     * @param subResource class representing matched sub resource.
     */
    public void requestSubResourcePreDispatch(long id, Class subResource);

    /**
     * Called right before resource method invocation.
     *
     * @param id     Context ID.
     * @param method method used for dispatching. It MUST NOT be modified.
     */
    public void requestResourceMethodPreDispatch(long id, AbstractResourceMethod method);

    /**
     * Called when exception is thrown during dispatching and not mapped via ExceptionMapper.
     *
     * @param id Context ID.
     * @param ex thrown exception.
     */
    public void error(long id, Throwable ex);

    /**
     * Called when Jersey has finalized response and handles it back to container.
     *
     * @param id       Context ID.
     * @param response response instance. It MUST NOT be modified.
     */
    public void requestEnd(long id, HttpServletResponse response);
}
