/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.config.configprovider;

import com.sun.faces.config.configprovider.ConfigurationResourceProvider;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.faces.FacesException;
import javax.servlet.ServletContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaInfResourceProvider
implements ConfigurationResourceProvider {
    private static final String META_INF_RESOURCES = "META-INF/faces-config.xml";

    @Override
    public List<URL> getResources(ServletContext context) {
        TreeMap<String, URL> sortedJarMap = new TreeMap<String, URL>();
        ArrayList<URL> unsortedResourceList = new ArrayList<URL>();
        try {
            Enumeration<URL> items = Util.getCurrentLoader(this).getResources(META_INF_RESOURCES);
            while (items.hasMoreElements()) {
                URL nextElement = items.nextElement();
                String jarUrl = nextElement.toString();
                String jarName = null;
                int resourceIndex = jarUrl.indexOf(META_INF_RESOURCES);
                if (resourceIndex != -1 && "jar".equals(nextElement.getProtocol())) {
                    int sepIndex;
                    int sep = 32;
                    for (sepIndex = resourceIndex - 2; 0 < sepIndex && 47 != (sep = (int)jarUrl.charAt(sepIndex)); --sepIndex) {
                    }
                    if (47 == sep) {
                        jarName = jarUrl.substring(sepIndex + 1, resourceIndex - 2);
                    }
                }
                if (null != jarName) {
                    sortedJarMap.put(jarName, nextElement);
                    continue;
                }
                unsortedResourceList.add(0, nextElement);
            }
        }
        catch (IOException e) {
            throw new FacesException((Throwable)e);
        }
        ArrayList<URL> result = new ArrayList<URL>(sortedJarMap.size() + unsortedResourceList.size());
        for (Map.Entry entry : sortedJarMap.entrySet()) {
            result.add((URL)entry.getValue());
        }
        result.addAll(unsortedResourceList);
        return result;
    }
}

