/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.ext.validator;

import com.sun.faces.ext.validator.MojarraMessageFactory;
import java.io.Serializable;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;

public class RegexValidator
implements Validator,
Serializable {
    private ValueExpression regex;

    public void setPattern(ValueExpression pattern) {
        this.regex = pattern;
    }

    public void validate(FacesContext context, UIComponent component, Object obj) {
        Locale locale = context.getViewRoot().getLocale();
        ELContext elcontext = context.getELContext();
        if (!this.regex.getType(elcontext).equals(String.class)) {
            FacesMessage fmsg = MojarraMessageFactory.getMessage(locale, "com.sun.faces.ext.validator.regexValidator.NOT_STRING", new Object[]{null});
            throw new ValidatorException(fmsg);
        }
        String regexStr = (String)this.regex.getValue(elcontext);
        if (!(obj instanceof String)) {
            FacesMessage fmsg = MojarraMessageFactory.getMessage(locale, "com.sun.faces.ext.validator.regexValidator.NOT_STRING", new Object[]{null});
            throw new ValidatorException(fmsg);
        }
        if (regexStr.equals("")) {
            FacesMessage fmsg = MojarraMessageFactory.getMessage(locale, "com.sun.faces.ext.validator.regexValidator.PATTERN_NOT_SET", new Object[]{null});
            throw new ValidatorException(fmsg);
        }
        try {
            Pattern pattern = Pattern.compile(regexStr);
            Matcher matcher = pattern.matcher((String)obj);
            if (!matcher.matches()) {
                Object[] params = new Object[]{regexStr};
                FacesMessage fmsg = MojarraMessageFactory.getMessage(locale, "com.sun.faces.ext.validator.regexValidator.NOT_MATCHED", params);
                throw new ValidatorException(fmsg);
            }
        }
        catch (PatternSyntaxException pse) {
            FacesMessage fmsg = MojarraMessageFactory.getMessage(locale, "com.sun.faces.ext.validator.regexValidator.EXP_ERR", new Object[]{null});
            throw new ValidatorException(fmsg, (Throwable)pse);
        }
    }
}

