/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.annotation;

import com.sun.jsftemplating.annotation.Handler;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.SimpleElementVisitor6;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"com.sun.jsftemplating.annotation.Handler", "com.sun.jsftemplating.annotation.HandlerInput", "com.sun.jsftemplating.annotation.HandlerOutput"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_6)
@SupportedOptions(value={"AnnotationVerifier.Annotations", "AnnotationVerifier.Baseclasses", "AnnotationVerifier.ClassAnnotation.Mappings"})
public class HandlerAP
extends AbstractProcessor {
    public static final String HANDLER_FILE = "META-INF/jsftemplating/Handler.map";
    private PrintWriter writer = null;
    private boolean _setup = false;
    private Map handlers = new HashMap();

    private boolean setup() {
        if (this._setup) {
            return true;
        }
        try {
            this.writer = this.getMapWriter();
        }
        catch (IOException ex) {
            StringWriter buf = new StringWriter();
            ex.printStackTrace(new PrintWriter(buf));
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Unable to write %s file while processing @FormatDefinition annotation %s", HANDLER_FILE, buf.toString()));
            return false;
        }
        this._setup = true;
        return this._setup;
    }

    private PrintWriter getMapWriter() throws IOException {
        PrintWriter _writer = null;
        ClassLoader cl = this.getClass().getClassLoader();
        Enumeration<URL> urls = cl.getResources(HANDLER_FILE);
        while (urls.hasMoreElements() && _writer == null) {
            URL url = urls.nextElement();
            if (url == null || !new File(url.getFile()).canRead()) continue;
            _writer = new PrintWriter(new FileOutputStream(url.getFile(), true));
        }
        if (_writer == null) {
            FileObject fo = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", HANDLER_FILE, new Element[0]);
            _writer = new PrintWriter(fo.openWriter());
            return _writer;
        }
        return _writer;
    }

    private static TypeElement getTypeElement(Element elt) {
        return elt.accept(new ElementVisitor(), null);
    }

    private static TypeElement getDeclaringTypeElement(Element elt) {
        return HandlerAP.getTypeElement(elt.getEnclosingElement());
    }

    private String getJavadocComments(Element elt) {
        return this.processingEnv.getElementUtils().getDocComment(elt);
    }

    private void writeIOProperties(String id, String type, List<AnnotationValue> ioList) {
        int cnt = 0;
        for (AnnotationValue ioVal : ioList) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> prop : ((AnnotationMirror)ioVal.getValue()).getElementValues().entrySet()) {
                this.writer.println(id + "." + type + "[" + cnt + "]." + prop.getKey().getSimpleName() + "=" + this.convertClassName(prop.getValue().getValue().toString()));
            }
            ++cnt;
        }
    }

    private String convertClassName(String str) {
        int idx = str.indexOf("[]");
        if (idx == -1) {
            return str;
        }
        int count = 0;
        while (idx != -1) {
            str = str.replaceFirst("\\[]", "");
            idx = str.indexOf("[]");
            ++count;
        }
        String brackets = "";
        for (idx = 0; idx < count; ++idx) {
            brackets = brackets + "[";
        }
        return brackets + "L" + str + ";";
    }

    private String formatComment(String javadoc) {
        if (javadoc == null) {
            return "";
        }
        int idx = javadoc.indexOf("@param");
        if (idx > -1) {
            javadoc = javadoc.substring(0, idx);
        }
        javadoc = javadoc.trim();
        StringBuilder buf = new StringBuilder("\n# ");
        int len = javadoc.length();
        block6: for (idx = 0; idx < len; ++idx) {
            char ch = javadoc.charAt(idx);
            switch (ch) {
                case '&': {
                    if (idx + 3 >= len || javadoc.charAt(idx + 2) != 't' || javadoc.charAt(idx + 3) != ';') continue block6;
                    if (javadoc.charAt(idx + 1) == 'g') {
                        buf.append('>');
                        idx += 3;
                        continue block6;
                    }
                    if (javadoc.charAt(idx + 1) != 'l') continue block6;
                    buf.append('<');
                    idx += 3;
                    continue block6;
                }
                case '<': {
                    ++idx;
                    while (idx < len && javadoc.charAt(idx) != '>') {
                        ++idx;
                    }
                    continue block6;
                }
                case '>': {
                    ++idx;
                    while (idx < len && javadoc.charAt(idx) != '<') {
                        ++idx;
                    }
                    continue block6;
                }
                case '\n': 
                case '\r': {
                    if (idx + 1 > len && (javadoc.charAt(idx + 1) == '\n' || javadoc.charAt(idx + 1) == '\r')) {
                        ++idx;
                    }
                    buf.append("\n# ");
                    continue block6;
                }
                default: {
                    buf.append(ch);
                }
            }
        }
        return buf.toString();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        if (SourceVersion.latest().compareTo(SourceVersion.RELEASE_6) > 0) {
            return SourceVersion.valueOf("RELEASE_7");
        }
        return SourceVersion.RELEASE_6;
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.setup();
        for (Element element : roundEnv.getElementsAnnotatedWith(Handler.class)) {
            for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
                String id = null;
                List input = null;
                List output = null;
                for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                    String key = entry.getKey().getSimpleName().toString();
                    Object value = entry.getValue().getValue();
                    if (key.equals("id")) {
                        id = value.toString();
                        continue;
                    }
                    if (key.equals("input")) {
                        input = (List)value;
                        continue;
                    }
                    if (!key.equals("output")) continue;
                    output = (List)value;
                }
                TypeElement te = HandlerAP.getTypeElement(element);
                TypeElement teDecl = HandlerAP.getDeclaringTypeElement(element);
                if (id == null) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("'id' is not specified for annotation of method: %s.%s", te.getQualifiedName().toString(), te.getSimpleName().toString()), element);
                }
                if (this.handlers.get(id) != null) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, String.format("Handler with 'id' of '%s' is declared more than once!'", id), element);
                }
                this.handlers.put(id, id);
                this.writer.println(this.formatComment(this.getJavadocComments(element)));
                this.writer.println(String.format("%s.class=%s", id, teDecl.getQualifiedName()));
                this.writer.println(String.format("%s.method=%s", id, element.getSimpleName()));
                if (input != null) {
                    this.writeIOProperties(id, "input", input);
                }
                if (output != null) {
                    this.writeIOProperties(id, "output", output);
                }
                if (!element.getModifiers().contains((Object)Modifier.PUBLIC)) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Annotated method: %s.%s should be declared public", teDecl.getQualifiedName().toString(), element.getSimpleName().toString()), element);
                }
                ExecutableElement exe = element.accept(new ExecutableElementVisitor(), null);
                List<? extends VariableElement> params = exe.getParameters();
                String pdec = params.iterator().next().asType().toString();
                if (params.size() == 1 && pdec.equals("com.sun.jsftemplating.layout.descriptors.handler.HandlerContext")) continue;
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("Annotated method: %s.%s  must contain a single parameter of type 'com.sun.jsftemplating.layout.descriptors.handler.HandlerContext', instead type: %s was found", teDecl.getQualifiedName(), element.getSimpleName(), pdec), element);
            }
        }
        if (this._setup) {
            this.writer.close();
        }
        return roundEnv.processingOver();
    }

    private static final class ExecutableElementVisitor
    extends SimpleElementVisitor6<ExecutableElement, Void> {
        private ExecutableElementVisitor() {
        }

        @Override
        public ExecutableElement visitExecutable(ExecutableElement e, Void p) {
            return e;
        }
    }

    private static final class ElementVisitor
    extends SimpleElementVisitor6<TypeElement, Void> {
        private ElementVisitor() {
        }

        @Override
        public TypeElement visitType(TypeElement e, Void p) {
            return e;
        }
    }
}

