/*
 * Decompiled with CFR 0.152.
 */
package javax.activation;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.activation.CommandObject;
import javax.activation.DataHandler;

public class CommandInfo {
    private String verb;
    private String className;

    public CommandInfo(String verb, String className) {
        this.verb = verb;
        this.className = className;
    }

    public String getCommandName() {
        return this.verb;
    }

    public String getCommandClass() {
        return this.className;
    }

    public Object getCommandObject(DataHandler dh, ClassLoader loader) throws IOException, ClassNotFoundException {
        Object new_bean = null;
        Class<?> beans = null;
        try {
            beans = Class.forName("java.beans.Beans", true, loader);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (beans != null) {
                Method m = beans.getMethod("instantiate", ClassLoader.class, String.class);
                new_bean = m.invoke(null, loader, this.className);
            } else {
                new_bean = Class.forName(this.className, true, loader).newInstance();
            }
        }
        catch (InvocationTargetException m) {
        }
        catch (InstantiationException m) {
        }
        catch (NoSuchMethodException m) {
        }
        catch (IllegalAccessException m) {
            // empty catch block
        }
        if (new_bean != null) {
            InputStream is;
            if (new_bean instanceof CommandObject) {
                ((CommandObject)new_bean).setCommandContext(this.verb, dh);
            } else if (new_bean instanceof Externalizable && dh != null && (is = dh.getInputStream()) != null) {
                ((Externalizable)new_bean).readExternal(new ObjectInputStream(is));
            }
        }
        return new_bean;
    }
}

