/*
 * $RCSfile: BMPMetadataFormatResources.java,v $
 *
 * 
 * Copyright (c) 2005 Sun Microsystems, Inc. All  Rights Reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met: 
 * 
 * - Redistribution of source code must retain the above copyright 
 *   notice, this  list of conditions and the following disclaimer.
 * 
 * - Redistribution in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in 
 *   the documentation and/or other materials provided with the
 *   distribution.
 * 
 * Neither the name of Sun Microsystems, Inc. or the names of 
 * contributors may be used to endorse or promote products derived 
 * from this software without specific prior written permission.
 * 
 * This software is provided "AS IS," without a warranty of any 
 * kind. ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND 
 * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY, 
 * FITNESS FOR A PARTICULAR PURPOSE OR NON-INFRINGEMENT, ARE HEREBY
 * EXCLUDED. SUN MIDROSYSTEMS, INC. ("SUN") AND ITS LICENSORS SHALL 
 * NOT BE LIABLE FOR ANY DAMAGES SUFFERED BY LICENSEE AS A RESULT OF 
 * USING, MODIFYING OR DISTRIBUTING THIS SOFTWARE OR ITS
 * DERIVATIVES. IN NO EVENT WILL SUN OR ITS LICENSORS BE LIABLE FOR 
 * ANY LOST REVENUE, PROFIT OR DATA, OR FOR DIRECT, INDIRECT, SPECIAL,
 * CONSEQUENTIAL, INCIDENTAL OR PUNITIVE DAMAGES, HOWEVER CAUSED AND
 * REGARDLESS OF THE THEORY OF LIABILITY, ARISING OUT OF THE USE OF OR
 * INABILITY TO USE THIS SOFTWARE, EVEN IF SUN HAS BEEN ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGES. 
 * 
 * You acknowledge that this software is not designed or intended for 
 * use in the design, construction, operation or maintenance of any 
 * nuclear facility. 
 *
 * $Revision: 1.2 $
 * $Date: 2006/04/14 21:29:14 $
 * $State: Exp $
 */
package com.sun.media.imageioimpl.plugins.bmp;

import java.util.ListResourceBundle;
import javax.imageio.metadata.IIOMetadataFormat;
import javax.imageio.metadata.IIOMetadataFormatImpl;

public class BMPMetadataFormatResources extends ListResourceBundle {

    public BMPMetadataFormatResources() {}

    protected Object[][] getContents() {
        return new Object[][] {

        // Node name, followed by description
        { "BMPVersion", "BMP version string" },
        { "Width", "The width of the image" },
        { "Height","The height of the image" },
        { "BitsPerPixel", "" },
	{ "PixelsPerMeter", "Resolution in pixels per unit distance" },
	{ "X", "Pixels Per Meter along X" },
	{ "Y", "Pixels Per Meter along Y" },
	{ "ColorsUsed",
	  "Number of color indexes in the color table actually used" },
	{ "ColorsImportant",
	  "Number of color indexes considered important for display" },
	{ "Mask",
	  "Color masks; present for BI_BITFIELDS compression only"},

	{ "Intent", "Rendering intent" },
	{ "Palette", "The color palette" },

	{ "Red", "Red Mask/Color Palette" },
	{ "Green", "Green Mask/Color Palette/Gamma" },
	{ "Blue", "Blue Mask/Color Palette/Gamma" },
	{ "Alpha", "Alpha Mask/Color Palette/Gamma" },

	{ "ColorSpaceType", "Color Space Type" },

	{ "X", "The X coordinate of a point in XYZ color space" },
	{ "Y", "The Y coordinate of a point in XYZ color space" },
	{ "Z", "The Z coordinate of a point in XYZ color space" },
        };
    }
}
