/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jerseyme.api.client;

import com.sun.jerseyme.api.client.RMSPropertyCache;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.rms.RecordStoreException;

class FilesystemUtils {
    private static Vector bbRoots = new Vector();

    FilesystemUtils() {
    }

    public static String getDefaultRoot(String rmsStoreName) {
        String returnVal = null;
        RMSPropertyCache rmsProps = null;
        try {
            System.out.println("RMS Store Name: " + rmsStoreName);
            rmsProps = new RMSPropertyCache(rmsStoreName);
        }
        catch (RecordStoreException ex) {
            System.out.println("Error loading lastRoot from RMS");
            ex.printStackTrace();
        }
        String lastRoot = rmsProps.get("lastRoot");
        if (lastRoot != null) {
            returnVal = lastRoot;
            System.out.println("    Found root in RMS: " + lastRoot);
        } else if (System.getProperty("microedition.platform").indexOf("RIM") != -1) {
            String homeMep = "store/home/user/mep/";
            String sdMep = "SDCard/mep/";
            if (FilesystemUtils.createAndTestRoot("store/home/user/mep/")) {
                returnVal = "store/home/user/mep/";
            } else if (FilesystemUtils.createAndTestRoot("SDCard/mep/")) {
                returnVal = "SDCard/mep/";
            } else {
                Enumeration e = bbRoots.elements();
                while (e.hasMoreElements()) {
                    String root = (String)e.nextElement();
                    if (!FilesystemUtils.testRoot(root)) continue;
                    returnVal = root;
                    break;
                }
            }
        } else {
            Enumeration roots = FileSystemRegistry.listRoots();
            while (roots.hasMoreElements()) {
                String root = (String)roots.nextElement();
                boolean writeable = FilesystemUtils.testRoot(root);
                if (!writeable) continue;
                returnVal = root;
                break;
            }
        }
        if (returnVal == null) {
            throw new RuntimeException("Unable to find a writable root folder");
        }
        try {
            if (rmsProps != null) {
                System.out.println("Saving root in RMS: " + returnVal);
                rmsProps.set("lastRoot", returnVal);
            }
        }
        catch (RecordStoreException ex) {
            System.out.println("Error storing root in RMS");
            ex.printStackTrace();
        }
        return returnVal;
    }

    private static boolean createAndTestRoot(String root) {
        try {
            FileConnection fc = (FileConnection)Connector.open((String)("file:///" + root), (int)3);
            if (!fc.exists()) {
                fc.mkdir();
            }
            fc.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean testRoot(String root) {
        try {
            String f = "file:///" + root;
            FileConnection fc = (FileConnection)Connector.open((String)f, (int)3);
            fc.close();
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    static {
        bbRoots.addElement("store/home/user/pictures/");
        bbRoots.addElement("store/home/user/music/");
        bbRoots.addElement("store/home/user/ringtones/");
        bbRoots.addElement("store/home/user/videos/");
    }
}

