/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jerseyme.api.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;

class RMSPropertyCache {
    private final String storeName;
    private Hashtable props;

    public RMSPropertyCache(String storeName) throws RecordStoreException {
        this.storeName = storeName;
        this.read();
    }

    public void set(String key, String value) throws RecordStoreException {
        String old = this.props.put(key, value);
        if (old == null || !old.equals(value)) {
            this.write();
        }
    }

    public void remove(String key) throws RecordStoreException {
        if (this.props.remove(key) != null) {
            this.write();
        }
    }

    public String get(String key) {
        return (String)this.props.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read() throws RecordStoreException {
        RecordStore rs = RecordStore.openRecordStore((String)this.storeName, (boolean)true);
        this.props = new Hashtable();
        try {
            RecordEnumeration re = rs.enumerateRecords(null, null, false);
            while (re.hasNextElement()) {
                byte[] record = re.nextRecord();
                this.parseRecord(record);
            }
        }
        finally {
            rs.closeRecordStore();
        }
    }

    private void parseRecord(byte[] record) {
        try {
            ByteArrayInputStream raw = new ByteArrayInputStream(record);
            DataInputStream in = new DataInputStream(raw);
            String key = in.readUTF();
            String value = in.readUTF();
            this.props.put(key, value);
        }
        catch (IOException ioe) {
            System.out.println("Bad record in " + this.storeName + ".");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write() throws RecordStoreException {
        try {
            RecordStore.deleteRecordStore((String)this.storeName);
        }
        catch (RecordStoreNotFoundException rsfe) {
            // empty catch block
        }
        RecordStore rs = RecordStore.openRecordStore((String)this.storeName, (boolean)true);
        try {
            Enumeration keys = this.props.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = (String)this.props.get(key);
                try {
                    byte[] record = this.packRecord(key, value);
                    rs.addRecord(record, 0, record.length);
                }
                catch (IOException ioe) {
                    System.out.println("Error packing in " + this.storeName + " : " + key + " -> " + value);
                }
            }
        }
        finally {
            rs.closeRecordStore();
        }
    }

    private byte[] packRecord(String key, String value) throws IOException {
        ByteArrayOutputStream raw = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(raw);
        out.writeUTF(key);
        out.writeUTF(value);
        return raw.toByteArray();
    }
}

