/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jerseyme.api.client;

import com.sun.jerseyme.api.client.Client;
import com.sun.jerseyme.api.client.FilesystemUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

class ResourceCache {
    private static final String FILE_PREFIX = "_cache";
    private static final long ONE_DAY = 86400000L;
    private static ResourceCache INSTANCE = null;
    private String fileUriPrefix = "file:///" + FilesystemUtils.getDefaultRoot("com.sun.jerseyme.api.client.rms");
    private long elapsedMillis = 86400000L;
    private boolean isLastGetStale = false;

    protected ResourceCache() {
    }

    static synchronized ResourceCache getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ResourceCache();
        }
        return INSTANCE;
    }

    public synchronized void setCachePolicy(long elapsedMillis) {
        this.elapsedMillis = elapsedMillis;
    }

    public synchronized void clearCache() {
        block4: {
            try {
                FileConnection dc = (FileConnection)Connector.open((String)this.fileUriPrefix);
                Enumeration e = dc.list("_cache*", true);
                while (e.hasMoreElements()) {
                    String cache = this.fileUriPrefix + (String)e.nextElement();
                    if (Client.isLogging) {
                        System.out.println("Clearing file " + cache);
                    }
                    FileConnection fc = (FileConnection)Connector.open((String)cache, (int)3);
                    fc.delete();
                    fc.close();
                }
            }
            catch (IOException ex) {
                if (!Client.isLogging) break block4;
                System.out.println("Unable to clear resource cache " + ex.getMessage());
                ex.printStackTrace();
            }
        }
    }

    public synchronized void setCacheFolder(String folder) throws IllegalArgumentException {
        if (folder.charAt(0) != '/' || folder.charAt(folder.length() - 1) != '/') {
            throw new IllegalArgumentException("Folder '" + folder + "' must start and end with '/'");
        }
        this.fileUriPrefix = "file://" + folder;
    }

    public boolean isLastGetStale() {
        return this.isLastGetStale;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized InputStream get(String uri) {
        FileConnection fc = null;
        try {
            int c;
            String fileUri = this.fileUriPrefix + FILE_PREFIX + String.valueOf(uri.hashCode());
            fc = (FileConnection)Connector.open((String)fileUri, (int)3);
            if (!fc.exists()) {
                InputStream inputStream = null;
                return inputStream;
            }
            long lastModified = fc.lastModified();
            if (lastModified == 0L && Client.isLogging) {
                System.out.println("FileConnection.lastModified() not supported. Clear cache to force re-fetch.");
                this.isLastGetStale = false;
            } else {
                boolean bl = this.isLastGetStale = System.currentTimeMillis() - lastModified > this.elapsedMillis;
            }
            if (Client.isLogging) {
                System.out.println("Reading cached " + uri + " from " + fileUri);
            }
            InputStream is = fc.openInputStream();
            int i = 0;
            while ((c = is.read()) != -1 && c != 32 && c == uri.charAt(i)) {
                ++i;
            }
            if (c == 32) {
                InputStream inputStream = is;
                return inputStream;
            }
            is.close();
            InputStream inputStream = null;
            return inputStream;
        }
        catch (IOException ex) {
            if (Client.isLogging) {
                System.out.println(ex.getMessage());
                ex.printStackTrace();
            }
        }
        finally {
            block26: {
                try {
                    if (fc != null) {
                        fc.close();
                    }
                }
                catch (IOException ex) {
                    if (!Client.isLogging) break block26;
                    System.out.println(ex.getMessage());
                    ex.printStackTrace();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void put(String uri, InputStream is) {
        FileConnection fc = null;
        try {
            int c;
            String fileUri = this.fileUriPrefix + FILE_PREFIX + String.valueOf(uri.hashCode());
            fc = (FileConnection)Connector.open((String)fileUri, (int)3);
            if (fc.exists()) {
                fc.delete();
            }
            fc.create();
            if (Client.isLogging) {
                System.out.println("Writing " + uri + " to " + fileUri);
            }
            OutputStream os = fc.openOutputStream();
            int n = uri.length();
            for (int i = 0; i < n; ++i) {
                os.write(uri.charAt(i));
            }
            os.write(32);
            while ((c = is.read()) != -1) {
                os.write(c);
            }
            os.close();
        }
        catch (IOException ex) {
            if (Client.isLogging) {
                System.err.println(ex.getMessage());
                ex.printStackTrace();
            }
        }
        finally {
            block18: {
                try {
                    if (fc != null) {
                        fc.close();
                    }
                }
                catch (IOException ex) {
                    if (!Client.isLogging) break block18;
                    System.err.println(ex.getMessage());
                    ex.printStackTrace();
                }
            }
        }
    }
}

