/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jerseyme.api.client;

import com.sun.jerseyme.api.client.ResourceCache;
import com.sun.jerseyme.api.client.UniformInterface;
import com.sun.jerseyme.api.client.UniformInterfaceException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class WebResource
implements UniformInterface {
    private static final int ONE_KB = 1024;
    private boolean isCached;
    private String uri;
    private HttpConnection connection = null;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$String;

    WebResource(String uri) throws UniformInterfaceException {
        this.uri = uri;
    }

    public boolean lastGetCached() {
        return this.isCached;
    }

    public Hashtable head() {
        try {
            String key;
            String newUri;
            this.setupConnection();
            this.connection.setRequestMethod("HEAD");
            int rc = this.connection.getResponseCode();
            if (rc > 300 && rc < 400 && (newUri = this.connection.getHeaderField("Location")) != null) {
                this.uri = newUri;
                Hashtable hashtable = this.head();
                return hashtable;
            }
            if (rc != 200) {
                throw new UniformInterfaceException("HTTP HEAD operation returned error code " + rc + " - " + this.connection.getResponseMessage());
            }
            Hashtable<String, String> result = new Hashtable<String, String>();
            int i = 0;
            while ((key = this.connection.getHeaderFieldKey(i)) != null) {
                result.put(key, this.connection.getHeaderField(i));
                ++i;
            }
            Hashtable<String, String> hashtable = result;
            return hashtable;
        }
        catch (IOException ex) {
            throw new UniformInterfaceException(ex);
        }
        finally {
            try {
                if (this.connection != null) {
                    this.connection.close();
                    this.connection = null;
                }
            }
            catch (IOException ex) {
                throw new UniformInterfaceException(ex);
            }
        }
    }

    public Object get(Class c) throws UniformInterfaceException {
        return this.get(c, false);
    }

    public Object get(Class c, boolean ignoreCache) throws UniformInterfaceException {
        try {
            this.setupConnection();
            this.isCached = false;
            InputStream is = null;
            ResourceCache cache = ResourceCache.getInstance();
            if (!ignoreCache && (is = cache.get(this.uri)) != null) {
                this.isCached = true;
            }
            if (!this.isCached || cache.isLastGetStale()) {
                int rc;
                block24: {
                    rc = -1;
                    try {
                        String newUri;
                        rc = this.connection.getResponseCode();
                        if (rc > 300 && rc < 400 && (newUri = this.connection.getHeaderField("Location")) != null) {
                            this.uri = newUri;
                            Object object = this.get(c);
                            return object;
                        }
                    }
                    catch (Exception ex) {
                        if (this.isCached) break block24;
                        throw new UniformInterfaceException("HTTP GET operation failed - " + ex.getMessage());
                    }
                }
                if (rc == 200) {
                    if (!ignoreCache) {
                        cache.put(this.uri, this.connection.openInputStream());
                        is = cache.get(this.uri);
                        if (is == null) {
                            throw new UniformInterfaceException("Caching operation for HTTP GET failed");
                        }
                    } else {
                        is = this.connection.openDataInputStream();
                    }
                } else if (!this.isCached) {
                    throw new UniformInterfaceException("HTTP GET operation returned error code " + rc + " - " + this.connection.getResponseMessage());
                }
            }
            Object object = this.convertContent(is, c);
            return object;
        }
        catch (IOException ex) {
            throw new UniformInterfaceException(ex);
        }
        finally {
            try {
                if (this.connection != null) {
                    this.connection.close();
                    this.connection = null;
                }
            }
            catch (IOException ex) {
                throw new UniformInterfaceException(ex);
            }
        }
    }

    public void post() throws UniformInterfaceException {
        this.doPost(null, null);
    }

    public void post(Object o) throws UniformInterfaceException {
        this.doPost(null, o);
    }

    public Object post(Class c) throws UniformInterfaceException {
        return this.doPost(c, null);
    }

    public Object post(Class c, Object o) throws UniformInterfaceException {
        return this.doPost(c, o);
    }

    public void put() throws UniformInterfaceException {
        this.setRequestProperty("X-HTTP-Method-Override", "PUT");
        this.post();
    }

    public Object put(Class c) throws UniformInterfaceException {
        this.setRequestProperty("X-HTTP-Method-Override", "PUT");
        return this.post(c);
    }

    public void put(Object o) throws UniformInterfaceException {
        this.setRequestProperty("X-HTTP-Method-Override", "PUT");
        this.post(o);
    }

    public Object put(Class c, Object o) throws UniformInterfaceException {
        this.setRequestProperty("X-HTTP-Method-Override", "PUT");
        return this.post(c, o);
    }

    public void delete() throws UniformInterfaceException {
        this.setRequestProperty("X-HTTP-Method-Override", "DELETE");
        this.post();
    }

    public Object delete(Class c) throws UniformInterfaceException {
        this.setRequestProperty("X-HTTP-Method-Override", "DELETE");
        return this.post(c);
    }

    public void delete(Object o) throws UniformInterfaceException {
        this.setRequestProperty("X-HTTP-Method-Override", "DELETE");
        this.post(o);
    }

    public Object delete(Class c, Object o) throws UniformInterfaceException {
        this.setRequestProperty("X-HTTP-Method-Override", "DELETE");
        return this.post(c, o);
    }

    public UniformInterface accept(String type) throws UniformInterfaceException {
        try {
            this.setupConnection();
            String value = this.connection.getRequestProperty("Accept");
            value = value == null ? type : type + "," + value;
            this.connection.setRequestProperty("Accept", value);
            return this;
        }
        catch (IOException ex) {
            throw new UniformInterfaceException(ex);
        }
    }

    public UniformInterface acceptLanguage(String type) throws UniformInterfaceException {
        this.setRequestProperty("Accept-Language", type);
        return this;
    }

    public UniformInterface cookie(String type) throws UniformInterfaceException {
        this.setRequestProperty("Cookie", type);
        return this;
    }

    public UniformInterface type(String type) throws UniformInterfaceException {
        this.setRequestProperty("Content-Type", type);
        return this;
    }

    private void setRequestProperty(String name, String value) throws UniformInterfaceException {
        try {
            this.setupConnection();
            this.connection.setRequestProperty(name, value);
        }
        catch (IOException ex) {
            throw new UniformInterfaceException(ex);
        }
    }

    private void setupConnection() throws IOException {
        try {
            if (this.connection == null) {
                this.connection = (HttpConnection)Connector.open((String)this.uri);
            }
        }
        catch (IOException ex) {
            throw new UniformInterfaceException(ex);
        }
    }

    private Object doPost(Class c, Object o) throws UniformInterfaceException {
        try {
            String newUri;
            int rc;
            this.setupConnection();
            this.connection.setRequestMethod("POST");
            if (o != null) {
                int ch;
                OutputStream os = this.connection.openOutputStream();
                InputStream is = null;
                if (o instanceof String) {
                    is = new ByteArrayInputStream(((String)o).getBytes());
                } else if (o instanceof byte[]) {
                    is = new ByteArrayInputStream((byte[])o);
                } else if (o instanceof InputStream) {
                    is = (InputStream)o;
                } else {
                    throw new UniformInterfaceException("Unsupported object type '" + o + "'");
                }
                while ((ch = ((InputStream)is).read()) != -1) {
                    os.write(ch);
                }
            }
            if ((rc = this.connection.getResponseCode()) > 300 && rc < 400 && (newUri = this.connection.getHeaderField("Location")) != null) {
                this.uri = newUri;
                Object object = this.doPost(c, o);
                return object;
            }
            if (rc < 200 || rc >= 400) {
                throw new UniformInterfaceException("HTTP POST operation returned error code " + rc + " - " + this.connection.getResponseMessage());
            }
            Object result = null;
            if (c != null) {
                result = this.convertContent(this.connection.openInputStream(), c);
            }
            Object object = result;
            return object;
        }
        catch (Exception ex) {
            throw new UniformInterfaceException(ex);
        }
        finally {
            try {
                if (this.connection != null) {
                    this.connection.close();
                    this.connection = null;
                }
            }
            catch (IOException ex) {
                throw new UniformInterfaceException(ex);
            }
        }
    }

    private Object convertContent(InputStream is, Class c) throws UniformInterfaceException {
        if (c == (class$java$io$InputStream == null ? (class$java$io$InputStream = WebResource.class$("java.io.InputStream")) : class$java$io$InputStream)) {
            return is;
        }
        try {
            int ch;
            ByteArrayOutputStream baos = new ByteArrayOutputStream(1024);
            while ((ch = is.read()) != -1) {
                baos.write(ch);
            }
            is.close();
            byte[] data = baos.toByteArray();
            if (c == (array$B == null ? (array$B = WebResource.class$("[B")) : array$B)) {
                return data;
            }
            if (c == (class$java$lang$String == null ? (class$java$lang$String = WebResource.class$("java.lang.String")) : class$java$lang$String)) {
                return new String(data);
            }
            throw new UniformInterfaceException("Unsupported parameter type '" + c + "'");
        }
        catch (IOException ex) {
            throw new UniformInterfaceException(ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

