/*
 * Decompiled with CFR 0.152.
 */
package jmunit.framework.cldc11;

import javax.microedition.midlet.MIDlet;
import jmunit.framework.cldc11.AssertionFailedException;

public abstract class Assertion
extends MIDlet {
    private static final String ASSERT_EQUALS_FAILED = "Assert equals failed.";
    private static final String ASSERT_NOT_EQUALS_FAILED = "Assert not equals failed.";

    public static final void assertNull(String string, Object object) throws AssertionFailedException {
        if (object != null) {
            Assertion.fail(string);
        }
    }

    public static final void assertNotNull(String string, Object object) throws AssertionFailedException {
        if (object == null) {
            Assertion.fail(string);
        }
    }

    public static final void assertTrue(String string, boolean bl) throws AssertionFailedException {
        if (!bl) {
            Assertion.fail(string);
        }
    }

    public static final void assertFalse(String string, boolean bl) throws AssertionFailedException {
        if (bl) {
            Assertion.fail(string);
        }
    }

    public static final void assertSame(String string, Object object, Object object2) throws AssertionFailedException {
        if (object != object2) {
            Assertion.fail(string);
        }
    }

    public static final void assertNotSame(String string, Object object, Object object2) throws AssertionFailedException {
        if (object == object2) {
            Assertion.fail(string, object, object2);
        }
    }

    public static final void assertEquals(String string, Object object, Object object2) throws AssertionFailedException {
        if (!object.equals(object2)) {
            Assertion.fail(string, object, object2);
        }
    }

    public static final void assertNotEquals(String string, Object object, Object object2) throws AssertionFailedException {
        if (object.equals(object2)) {
            Assertion.fail(string, object, object2);
        }
    }

    public static final void assertEquals(String string, boolean bl, boolean bl2) throws AssertionFailedException {
        if (bl != bl2) {
            Assertion.fail(string, bl, bl2);
        }
    }

    public static final void assertNotEquals(String string, boolean bl, boolean bl2) throws AssertionFailedException {
        if (bl == bl2) {
            Assertion.fail(string, bl, bl2);
        }
    }

    public static final void assertEquals(String string, char c, char c2) throws AssertionFailedException {
        if (c != c2) {
            Assertion.fail(string, c, c2);
        }
    }

    public static final void assertNotEquals(String string, char c, char c2) throws AssertionFailedException {
        if (c == c2) {
            Assertion.fail(string, c, c2);
        }
    }

    public static final void assertEquals(String string, int n, int n2) throws AssertionFailedException {
        if (n != n2) {
            Assertion.fail(string, n, n2);
        }
    }

    public static final void assertNotEquals(String string, int n, int n2) throws AssertionFailedException {
        if (n == n2) {
            Assertion.fail(string, n, n2);
        }
    }

    public static final void assertEquals(String string, byte by, byte by2) throws AssertionFailedException {
        if (by != by2) {
            Assertion.fail(string, by, by2);
        }
    }

    public static final void assertNotEquals(String string, byte by, byte by2) throws AssertionFailedException {
        if (by == by2) {
            Assertion.fail(string, by, by2);
        }
    }

    public static final void assertEquals(String string, long l, long l2) throws AssertionFailedException {
        if (l != l2) {
            Assertion.fail(string, l, l2);
        }
    }

    public static final void assertNotEquals(String string, long l, long l2) throws AssertionFailedException {
        if (l == l2) {
            Assertion.fail(string, l, l2);
        }
    }

    public static final void assertEquals(String string, short s, short s2) throws AssertionFailedException {
        if (s != s2) {
            Assertion.fail(string, s, s2);
        }
    }

    public static final void assertEquals(String string, float f, float f2) throws AssertionFailedException {
        if (f != f2) {
            Assertion.fail(string, f, f2);
        }
    }

    public static final void assertNotEquals(String string, float f, float f2) throws AssertionFailedException {
        if (f == f2) {
            Assertion.fail(string, f, f2);
        }
    }

    public static final void assertEquals(String string, double d, double d2) throws AssertionFailedException {
        if (d != d2) {
            Assertion.fail(string, d, d2);
        }
    }

    public static final void assertNotEquals(String string, double d, double d2) throws AssertionFailedException {
        if (d == d2) {
            Assertion.fail(string, d, d2);
        }
    }

    public static final void assertNotEquals(String string, short s, short s2) throws AssertionFailedException {
        if (s == s2) {
            Assertion.fail(string, s, s2);
        }
    }

    public static final void assertNull(Object object) throws AssertionFailedException {
        Assertion.assertNull("Assert null failed.", object);
    }

    public static final void assertNotNull(Object object) throws AssertionFailedException {
        Assertion.assertNotNull("Assert not null failed.", object);
    }

    public static final void assertTrue(boolean bl) throws AssertionFailedException {
        Assertion.assertTrue("Assert true failed.", bl);
    }

    public static final void assertFalse(boolean bl) throws AssertionFailedException {
        Assertion.assertFalse("Assert false failed.", bl);
    }

    public static final void assertSame(Object object, Object object2) throws AssertionFailedException {
        Assertion.assertSame("Assert same failed.", object, object2);
    }

    public static final void assertNotSame(Object object, Object object2) throws AssertionFailedException {
        Assertion.assertNotSame("Assert not same failed.", object, object2);
    }

    public static final void assertEquals(Object object, Object object2) throws AssertionFailedException {
        Assertion.assertEquals(ASSERT_EQUALS_FAILED, object, object2);
    }

    public static final void assertNotEquals(Object object, Object object2) throws AssertionFailedException {
        Assertion.assertNotEquals(ASSERT_NOT_EQUALS_FAILED, object, object2);
    }

    public static final void assertEquals(boolean bl, boolean bl2) throws AssertionFailedException {
        Assertion.assertEquals(ASSERT_EQUALS_FAILED, bl, bl2);
    }

    public static final void assertNotEquals(boolean bl, boolean bl2) throws AssertionFailedException {
        Assertion.assertNotEquals(ASSERT_NOT_EQUALS_FAILED, bl, bl2);
    }

    public static final void assertEquals(char c, char c2) throws AssertionFailedException {
        Assertion.assertEquals(ASSERT_EQUALS_FAILED, c, c2);
    }

    public static final void assertNotEquals(char c, char c2) throws AssertionFailedException {
        Assertion.assertNotEquals(ASSERT_NOT_EQUALS_FAILED, c, c2);
    }

    public static final void assertEquals(int n, int n2) throws AssertionFailedException {
        Assertion.assertEquals(ASSERT_EQUALS_FAILED, n, n2);
    }

    public static final void assertNotEquals(int n, int n2) throws AssertionFailedException {
        Assertion.assertNotEquals(ASSERT_NOT_EQUALS_FAILED, n, n2);
    }

    public static final void assertEquals(byte by, byte by2) throws AssertionFailedException {
        Assertion.assertEquals(ASSERT_EQUALS_FAILED, by, by2);
    }

    public static final void assertNotEquals(byte by, byte by2) throws AssertionFailedException {
        Assertion.assertNotEquals(ASSERT_NOT_EQUALS_FAILED, by, by2);
    }

    public static final void assertEquals(long l, long l2) throws AssertionFailedException {
        Assertion.assertEquals(ASSERT_EQUALS_FAILED, l, l2);
    }

    public static final void assertNotEquals(long l, long l2) throws AssertionFailedException {
        Assertion.assertNotEquals(ASSERT_NOT_EQUALS_FAILED, l, l2);
    }

    public static final void assertEquals(short s, short s2) throws AssertionFailedException {
        Assertion.assertEquals(ASSERT_EQUALS_FAILED, s, s2);
    }

    public static final void assertNotEquals(short s, short s2) throws AssertionFailedException {
        Assertion.assertNotEquals(ASSERT_NOT_EQUALS_FAILED, s, s2);
    }

    public static final void assertEquals(float f, float f2) throws AssertionFailedException {
        Assertion.assertEquals(ASSERT_EQUALS_FAILED, f, f2);
    }

    public static final void assertNotEquals(float f, float f2) throws AssertionFailedException {
        Assertion.assertNotEquals(ASSERT_NOT_EQUALS_FAILED, f, f2);
    }

    public static final void assertEquals(double d, double d2) throws AssertionFailedException {
        Assertion.assertEquals(ASSERT_EQUALS_FAILED, d, d2);
    }

    public static final void assertNotEquals(double d, double d2) throws AssertionFailedException {
        Assertion.assertNotEquals(ASSERT_NOT_EQUALS_FAILED, d, d2);
    }

    public static final void fail(String string) throws AssertionFailedException {
        throw new AssertionFailedException(string);
    }

    public static final void fail(String string, short s, short s2) throws AssertionFailedException {
        Assertion.fail(string, new Short(s), new Short(s2));
    }

    public static final void fail(String string, float f, float f2) throws AssertionFailedException {
        Assertion.fail(string, new Float(f), new Float(f2));
    }

    public static final void fail(String string, double d, double d2) throws AssertionFailedException {
        Assertion.fail(string, new Double(d), new Double(d2));
    }

    public static final void fail(String string, long l, long l2) throws AssertionFailedException {
        Assertion.fail(string, new Long(l), new Long(l2));
    }

    public static final void fail(String string, byte by, byte by2) throws AssertionFailedException {
        Assertion.fail(string, new Byte(by), new Byte(by2));
    }

    public static final void fail(String string, int n, int n2) throws AssertionFailedException {
        Assertion.fail(string, new Integer(n), new Integer(n2));
    }

    public static final void fail(String string, char c, char c2) throws AssertionFailedException {
        Assertion.fail(string, new Character(c), new Character(c2));
    }

    public static final void fail(String string, boolean bl, boolean bl2) throws AssertionFailedException {
        Assertion.fail(string, new Boolean(bl), new Boolean(bl2));
    }

    public static final void fail(String string, Object object, Object object2) throws AssertionFailedException {
        if (string == null) {
            string = "";
        } else if (!(string = string.trim()).endsWith(".")) {
            string = string + ".";
        }
        String string2 = string + " Expected " + object + ", but was " + object2 + ".";
        Assertion.fail(string2);
    }

    public static final void fail() throws AssertionFailedException {
        Assertion.fail(null);
    }
}

