/*
 * Decompiled with CFR 0.152.
 */
package jmunit.framework.cldc11;

import jmunit.framework.cldc11.Assertion;
import jmunit.framework.cldc11.PerformanceMeasurement;

public class TimedMeasurement
implements PerformanceMeasurement {
    private static final int JTWI_MIN_CLOCK_RESOLUTION = 40;
    private long startTime;
    private long maxRunningTime;
    private int clockResolution;

    public TimedMeasurement(long l) {
        this(l, 40);
    }

    public TimedMeasurement(long l, int n) {
        this.maxRunningTime = l;
        this.clockResolution = n;
        this.startMeasurement();
    }

    public void startMeasurement() {
        this.startTime = System.currentTimeMillis();
        if (this.clockResolution == 0) {
            while (System.currentTimeMillis() == this.startTime) {
            }
            this.startTime = System.currentTimeMillis();
        }
    }

    public void endMeasurement() {
        long l = System.currentTimeMillis() - this.startTime;
        Assertion.assertTrue("Test took too long: " + l + " ms.", l <= this.maxRunningTime + (long)this.clockResolution);
    }
}

