/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2008-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.pkg.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;

/**
 * A <code>FileAction</code> is an action that represents a file within the
 * image.
 * @author trm
 */
public final class FileAction extends AbstractFileAction implements FileList.DataSink {
    Fmri fmri;
    String hash;
    int size;
    File gzipfile;
    
    FileAction(Image image, Fmri f, String tokens[]) {
        super(6,image,tokens);
        fmri = f;
        hash = tokens[1];
        for (int i = 2; i < tokens.length; i++) {
            if (tokens[i].startsWith("pkg.size=")) {
                size = Integer.parseInt(tokens[i].substring(9));
            }
            // Note: some attributes such as elfhash, elfarch, etc. are skipped
        }
    }
    
    public String getHash() {
        return hash;
    }

    /**
     * Gets the size of this file.
     */
    @Override
    public int getSize() {
        return size;
    }

    public void setGzipFile(File f) {
        gzipfile = f;
    }
        
    @Override
    void buildFileList(Action orig, FileList flist) { 
        flist.add(this);
    }

    void install(Action orig) throws IOException {
        if (gzipfile == null || path == null) return;
        File target = new File(img.getRootDirectory(), path);
        // Make sure we can overwrite an old copy of the file by removing it
        // first.
        target.delete();
        target.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(target);
        GZIPInputStream gis = new GZIPInputStream(new FileInputStream(gzipfile));
        byte buf[] = new byte[4096];
        int n;
        while ((n = gis.read(buf)) > 0) {
            fos.write(buf, 0, n);
        }
        fos.close();
        gis.close();
        setPermissions(target, mode);
    }
    
    @Override
    public String toString() {
        return "file: path=" + path;
    }

    boolean isDifferent(Action a) {
        if (!(a instanceof FileAction)) return true;
        FileAction fa = (FileAction)a;
        return !equals(a) ||
                !hash.equals(fa.hash) ||
                !owner.equals(fa.owner) ||
                !group.equals(fa.group) ||
                !mode.equals(fa.mode);
    }
}
