/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2008-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.pkg.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

/**
 * PEMUtil provides utilities for dealing with PEM files. (OpenSSL certificate 
 * and key files)
 * 
 */
public class PEMUtil {
    private static final String RSA_OID = "1.2.840.113549.1.1.1";

    /* 
     * Set the SSLSocketFactory for the given HttpsURLConnection so that that
     * it uses the given client certificate
     */
    public static SSLSocketFactory getSSLSocketFactory(File certfile, File keyfile) 
            throws IOException {
        try {

            TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager() {

                public java.security.cert.X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                public void checkClientTrusted(java.security.cert.X509Certificate[] certs, String authType) {
                }

                public void checkServerTrusted(java.security.cert.X509Certificate[] certs, String authType) {
                }
            }};
            KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
            String password = "dummy";
            KeyStore keystore = getKeyStore(certfile, keyfile, password);
            kmf.init(keystore, password.toCharArray());
            KeyManager[] managers = kmf.getKeyManagers();

            SSLContext sc = SSLContext.getInstance("SSL");
            sc.init(managers, trustAllCerts, null);
            return sc.getSocketFactory();
        } catch (GeneralSecurityException ex) {
            Logger.getLogger(PEMUtil.class.getName()).log(Level.SEVERE, null, ex);
            throw new IOException("invalid certificate/key for SSL connection");
        }
    }

            
    /*
     * Get a KeyStore containing a certificate and private key taken from the
     * certfile and keyfile.  The cert/key is stored using the alias name 
     * "clientcert". The password is used for storing the key information to the
     * KeyStore.
     */
    static KeyStore getKeyStore(File certfile, File keyfile, String password) 
            throws IOException {
        try {

            PrivateKey privKey = getPrivateKey(keyfile);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate[] certchain = {cf.generateCertificate(new FileInputStream(certfile))};
            KeyStore keystore = KeyStore.getInstance("PKCS12");
            keystore.load(null, null);
            keystore.setKeyEntry("clientcert", privKey, password.toCharArray(), certchain);
            return keystore;
        } catch (GeneralSecurityException ex) {
            Logger.getLogger(PEMUtil.class.getName()).log(Level.SEVERE, null, ex);
            IOException ioe = new IOException("invalid certificate or key file");
            ioe.initCause(ex);
            throw ioe;
        }
    }
    
    static PrivateKey getPrivateKey(File infile) throws IOException {
        try {
            byte[] key = Base64.decode(new FileInputStream(infile));

            DerOutputStream temp;

            // Encode the key using DER.  The key is encoded as:
            // (0, (OID, Null), keyoctets)
            // where the parenthesis represent DER sequences.

            DerValue[] outer = new DerValue[3];
            temp = new DerOutputStream();
            temp.putInteger(BigInteger.ZERO);
            outer[0] = new DerValue(temp.toByteArray());

            DerValue[] innervec = new DerValue[2];
            temp = new DerOutputStream();
            temp.putOID(new ObjectIdentifier(RSA_OID));
            innervec[0] = new DerValue(temp.toByteArray());

            temp = new DerOutputStream();
            temp.putNull();
            innervec[1] = new DerValue(temp.toByteArray());
            DerOutputStream inner = new DerOutputStream();
            inner.putSequence(innervec);
            outer[1] = new DerValue(inner.toByteArray());

            temp = new DerOutputStream();
            temp.putOctetString(key);
            outer[2] = new DerValue(temp.toByteArray());

            DerOutputStream derout = new DerOutputStream();
            derout.putSequence(outer);
            byte[] dkey = derout.toByteArray();

            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            return keyFactory.generatePrivate(new PKCS8EncodedKeySpec(dkey));
        } catch (GeneralSecurityException ex) {
            Logger.getLogger(PEMUtil.class.getName()).log(Level.SEVERE, null, ex);
            IOException ioe = new IOException("invalid key file");
            ioe.initCause(ex);
            throw ioe;
        }
    }
}
