/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2008-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.pkg.client;

import java.io.IOException;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

/**
 * Common part between {@link DirAction} and {@link FileAction}, which stems from the fact
 * that they both involve in an object in a directory that has the same set of metadata.
 *
 * @author Kohsuke Kawaguchi
 */
public abstract class AbstractFileAction extends Action {
    Image img;
    String path = "";
    String owner = "";
    String group = "";
    String mode = "";

    /*package*/ AbstractFileAction(int k, Image image, String tokens[]) {
        super(k, tokens);
        img = image;
        for (int i = 1; i < tokens.length; i++) {
            if (tokens[i].startsWith("owner=")) owner = tokens[i].substring(6);
            else if (tokens[i].startsWith("path=")) path = tokens[i].substring(5);
            else if (tokens[i].startsWith("mode=")) mode = tokens[i].substring(5);
            else if (tokens[i].startsWith("group=")) group = tokens[i].substring(6);
        }
    }

    /**
     * Gets the path of the directory/file.
     *
     * @return
     *      string like "usr/lib"
     */
    public String getPath() {
        return path;
    }

    /**
     * Owner of the directory/file.
     *
     * @return
     *      string like "root"
     */
    public String getOwner() {
        return owner;
    }

    /**
     * Group of the directory/file.
     *
     * @return
     *      string like "sys"
     */
    public String getGroup() {
        return group;
    }

    /**
     * Directory permission mode in the octal format.
     *
     * @return
     *      String like "0644".
     */
    public String getMode() {
        return mode;
    }

    @Override
    void remove() throws IOException { 
        File target = new File(img.getRootDirectory(), path);
        setPermissions(target, "0644");
        target.delete();
    }

    @Override
    String keyValue() {
        return path;
    }

    /**
     * Get the list of directories referenced by this action.
     * @return a List of Files representing referenced directories or null if
     * there aren't any
     */
    @Override
    List<String> getReferencedDirectories() {
        List<String> l = new ArrayList<String>();
        File parent = new File(path).getParentFile();
        while (parent != null) {
            l.add(parent.toString());
            parent = parent.getParentFile();
        }
        return l;
    }
}
