/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2008-2011 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.pkg.client;

import java.io.BufferedInputStream;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.net.URLEncoder;
import java.io.IOException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.logging.Level;

import java.util.concurrent.Callable;

/**
 * A <code>DownloadFileTask</code> is a runnable that knows how to download
 * a file.
 * 
 * @author jfd
 */
class DownloadFileTask implements Callable<File> {

    Image img;
    List<FileList.DataSink> fal;
    Fmri fmri;
    File download_dir;
    int nfile;
    ImagePlanProgressTracker tracker;

    private DownloadFileTask() {
    }

    public DownloadFileTask(
        Image   img,
        List<FileList.DataSink> fal,
        Fmri  fmri,
        File  download_dir,
        int     nfile,
        ImagePlanProgressTracker tracker)

    {
        this.img = img;
        this.fal = fal;
        this.fmri = fmri;
        this.download_dir = download_dir;
        this.nfile = nfile;
        this.tracker = tracker;
    }

    @Override
    public File call() throws IOException {
        return download();
    }

    /**
     * Download the file
     */
    public File download() throws IOException {

        // Buffer for reading 
        byte[] buf = new byte[32 * 1024];

        FileList.DataSink fa = fal.get(0);
        String hash = fa.getHash();
        String hv = URLEncoder.encode(hash, "UTF-8");

        // Make connection to repo
        HttpURLConnection uc = img.getRepositoryURLConnection("file/0/" + hv,
                                                              fmri);
        img.checkRepositoryConnection(uc);

        // Read
        BufferedInputStream tis = new BufferedInputStream(uc.getInputStream());
        String outfilename = hash;
        img.getLogger().log(Level.FINER, "downloading", outfilename);
        tracker.startFileDownload(nfile, fa.getSize());

        File gzipfile = new File(download_dir, outfilename);
        fa.setGzipFile(gzipfile);
        OutputStream fos = new FileOutputStream(gzipfile);
        long xferedBytes = 0;
        while (true) {
            int numRead = tis.read(buf, 0, buf.length);
            if (numRead == -1) break;
            fos.write(buf, 0, numRead);
            xferedBytes += numRead;
            tracker.onFileDownloadProgress(nfile, xferedBytes);
        }
        tracker.onFileDownloadProgress(nfile, xferedBytes); // make sure this is called at least once

        fos.close();
        tracker.endFileDownload(nfile++, fa.getSize());
        for (int j = 1; j < fal.size(); j++) {
            FileList.DataSink nfa = fal.get(j);
            nfa.setGzipFile(gzipfile);
        }
        return gzipfile;
    }
}
