/*
 *  CDDL HEADER START
 *  The contents of this file are subject to the terms
 *  of the Common Development and Distribution License
 *  (the License). You may not use this file except in
 *  compliance with the License.
 * 
 *  You can obtain a copy of the License at
 *  http://www.sun.com/cddl/cddl.html and legal/CDDLv1.0.txt
 *  See the License for the specific language governing
 *  permission and limitations under the License.
 * 
 *  When distributing Covered Code, include this CDDL
 *  Header Notice in each file and include the License file
 *  at legal/CDDLv1.0.txt.
 *  If applicable, add the following below the CDDL Header,
 *  with the fields enclosed by brackets [] replaced by
 *  your own identifying information:
 *  "Portions Copyrighted [year] [name of copyright owner]"
 * 
 *  Copyright 2008 Sun Microsystems Inc. All Rights Reserved
 *  CDDL HEADER END
 */

package com.sun.pkg.client;

import com.sun.pkg.client.Image.FmriState;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.List;

/**
 * A simple CLI for pkg-java.
 * @author trm
 */
class Client {
    static final String usage = 
            "Usage:\n" +
            "    java -jar pkg-client.jar [options] command [cmd_options] [operands]\n" +
            "where command is one of:\n" +
            "    list [-a]            - list packages, list all with -a\n" +
            "    install [-l] pkgs... - install packages, list license(s) with -l\n" +
            "    uninstall pkgs...    - uninstall packages\n" +
            "    image-update [-n]    - update each installed package to the most recent version\n" +
            "                           just print with -n, do not actually update\n" +
            "    refresh              - refresh the catalogs\n" +
            "    prefs                - print information from preferences (proxy, update check)\n";
    
    public static void main(String args[]) throws Exception {
        File cwd = new File(System.getProperty("user.dir"));
        if (args.length >= 1 && args[0].equals("list")) {
            boolean all = false;
            if (args.length >= 2 && args[1].equals("-a")) all = true;
            Image img = new Image(cwd);
            List<Image.FmriState> list = img.getInventory(null, all);
            for (Image.FmriState fs : list) {
                StringBuffer sb = new StringBuffer();
                StringBuffer flags = new StringBuffer();
                sb.append(fs.fmri.toString());
                sb.append(" - " + fs.fmri.getAuthority());
                if (fs.installed) flags.append("I");
                if (fs.upgradable) flags.append("U");
                if (flags.length() > 0) {
                    sb.append(" (").append(flags).append(")");
                }
                System.out.println(sb);
            }
        }
        else if (args.length == 1 && args[0].equals("refresh")) {
            Image img = new Image(cwd);
            img.refreshCatalogs();
        }
        else if (args.length >= 1 && args[0].equals("install")) {
            boolean showLicenses = false;
            ArrayList<String> pnames = new ArrayList<String>();
            for (int i = 1; i < args.length; i++) {
                if (args[i].equals("-l")) showLicenses = true;
                else pnames.add(args[i]);
            }
            Image img = new Image(cwd);
            if (showLicenses) {
                Image.ImagePlan ip = img.makeInstallPlan(pnames.toArray(new String[0]));
                StringBuffer licenseText = new StringBuffer();
                for (Fmri f : ip.getProposedFmris()) {
                    Manifest m = img.getManifest(f);
                    List<LicenseAction> lla = m.getActionsByType(LicenseAction.class);
                    for (LicenseAction la : lla) {
                        licenseText.append("===== ").append(la.getName()).append(" =====\n");
                        licenseText.append("\n");
                        licenseText.append(la.getText());
                        licenseText.append("\n\n");
                    }
                }
                if (licenseText.length() > 0) {
                    System.out.println(licenseText);
                }
                ip.execute();
            }
            else {
                img.installPackages(pnames.toArray(new String[0]));
            }
        }
        else if (args.length >= 1 && args[0].equals("uninstall")) {
            String pnames[] = new String[args.length - 1];
            for (int i = 1; i < args.length; i++) {
                pnames[i - 1] = args[i];
            }
            Image img = new Image(cwd);
            img.uninstallPackages(pnames);
        }
        else if (args.length >= 1 && args[0].equals("image-update")) {
            boolean noexec = args.length >= 2 && args[1].equals("-n") ? true : false;
            Image img = new Image(cwd);
            List<Image.FmriState> installed = img.getInventory(null, false);
            String ipkgs[] = new String[installed.size()];
            int i = 0;
            for (Image.FmriState fs : installed) ipkgs[i++] = fs.fmri.getName();
            Image.ImagePlan ip = img.makeInstallPlan(ipkgs);
            Fmri[] proposed = ip.getProposedFmris();
            if (proposed.length > 0) {
                System.out.println("The following installed packages will be updated:");
                for (Image.FmriState fs : installed) {
                    for (Fmri p : proposed) {
                        if (fs.fmri.getName().equals(p.getName())) {
                            System.out.println("" + fs.fmri + " -> " + p);
                        }
                    }
                }
                if (!noexec) {
                    System.out.println("Updating the image...");
                    ip.execute();
                }
           } else {
                System.out.println("No packages need to be updated.");
           }
        }
        else if (args.length == 1 && args[0].equals("prefs")) {
            Proxy p = SystemInfo.getProxy();
            if (p == null) {
                System.out.println("no proxy");
            }
            else {
                InetSocketAddress isa = (InetSocketAddress)p.address();
                System.out.println("proxy: " + isa.getHostName() + ":" + isa.getPort());
            }
            System.out.println("update check frequency: " + SystemInfo.getUpdateCheckFrequency());
        }
        else if (args.length == 1 && args[0].equals("test")) {
        }
        else {
            System.err.println(usage);
            System.exit(1);
        }
        System.exit(0);
    }
}
