/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or updatetool/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.pkg.client;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;

/**
 * A <code>FileAction</code> is an action that represents a file within the
 * image.
 * @author trm
 */
class FileAction extends Action implements FileList.DataSink {
    Image img;
    Fmri fmri;
    String path = "";
    String hash;
    String owner = "";
    String group = "";
    String mode = "";
    int size;
    File gzipfile;
    
    FileAction(Image image, Fmri f, String tokens[]) {
        super(6);
        img = image;
        fmri = f;
        hash = tokens[1];
        for (int i = 2; i < tokens.length; i++) {
            if (tokens[i].startsWith("owner=")) owner = tokens[i].substring(6);
            else if (tokens[i].startsWith("path=")) path = tokens[i].substring(5);
            else if (tokens[i].startsWith("mode=")) mode = tokens[i].substring(5);
            else if (tokens[i].startsWith("group=")) group = tokens[i].substring(6);
            else if (tokens[i].startsWith("pkg.size=")) {
                size = Integer.parseInt(tokens[i].substring(9));
            }
            // Note: some attributes such as elfhash, elfarch, etc. are skipped
        }
    }
    
    public String getHash() {
        return hash;
    }
    
    @Override
    public int getSize() {
        return size;
    }
    
    public void setGzipFile(File f) {
        gzipfile = f;
    }
        
    @Override
    void preinstall(Action orig, FileList flist) { 
        flist.add(this);
    }

    void install(Action orig) throws IOException {
        if (gzipfile == null || path == null) return;
        File target = new File(img.getRootDirectory(), path);
        // Make sure we can overwrite an old copy of the file by removing it
        // first.
        target.delete();
        target.getParentFile().mkdirs();
        FileOutputStream fos = new FileOutputStream(target);
        GZIPInputStream gis = new GZIPInputStream(new FileInputStream(gzipfile));
        byte buf[] = new byte[4096];
        int n;
        while ((n = gis.read(buf)) > 0) {
            fos.write(buf, 0, n);
        }
        fos.close();
        gis.close();
        setPermissions(target, mode);
    }

    @Override
    void remove() throws IOException { 
        File target = new File(img.getRootDirectory(), path);
        setPermissions(target, "0644");
        target.delete();
    }

    /**
     * Get the list of directories referenced by this action.
     * @return a List of Files representing referenced directories or null if
     * there aren't any
     */
    @Override
    List<File> getReferencedDirectories() {
        List<File> l = new ArrayList<File>(1);
        l.add(new File(path).getParentFile());
        return l;
    }
    
    @Override
    String keyValue() { 
        return path; 
    }

    @Override
    public String toString() {
        return "file: path=" + path;
    }

    boolean isDifferent(Action a) {
        if (!(a instanceof FileAction)) return true;
        FileAction fa = (FileAction)a;
        return !equals(a) ||
                !hash.equals(fa.hash) ||
                !owner.equals(fa.owner) ||
                !group.equals(fa.group) ||
                !mode.equals(fa.mode);
    }
}
