/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or updatetool/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.pkg.client;

import java.io.File;
import java.io.IOException;

/**
 * A <code>DirAction</code> is an action that represents a directory within the
 * image.
 * 
 * @author trm
 */
class DirAction extends Action {
    Image img;
    String path = "";
    String owner = "";
    String group = "";
    String mode = "";

    DirAction(Image image, String tokens[]) {
        super(5);
        img = image;
        for (int i = 1; i < tokens.length; i++) {
            if (tokens[i].startsWith("owner=")) owner = tokens[i].substring(6);
            else if (tokens[i].startsWith("path=")) path = tokens[i].substring(5);
            else if (tokens[i].startsWith("mode=")) mode = tokens[i].substring(5);
            else if (tokens[i].startsWith("group=")) group = tokens[i].substring(6);
        }
    }
    
    void install(Action orig) throws IOException {
        File f = new File(img.getRootDirectory(), path);
        f.mkdirs();
        setPermissions(f, mode);
    }
    
    @Override
    void remove() throws IOException { 
        File target = new File(img.getRootDirectory(), path);
        setPermissions(target, "0644");
        target.delete();
    }

    @Override
    String keyValue() { 
        return path; 
    }
    
    @Override
    public String toString() {
        return "dir: path=" + path;
    }

    boolean isDifferent(Action a) {
        if (!(a instanceof DirAction)) return true;
        DirAction da = (DirAction)a;
        return !equals(a) ||
                !owner.equals(da.owner) ||
                !group.equals(da.group) ||
                !mode.equals(da.mode);
    }
}
