/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or updatetool/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.pkg.client;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.util.List;
import java.util.ArrayList;
import java.util.Map;
import java.util.HashMap;
import java.util.Iterator;
import java.net.URLEncoder;
import java.io.IOException;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.net.HttpURLConnection;
import java.util.logging.Level;
import org.apache.tools.tar.TarInputStream;
import org.apache.tools.tar.TarEntry;

/**
 * A <code>FileList</code> is a list of files that need to be downloaded from 
 * a repository. 
 * 
 * @author trm
 */
class FileList {
    
    interface DataSink {
        String getHash();
        int getSize();
        void setGzipFile(File f);
    }

    static final int max_bytes = 1024 * 1024; // amount downloaded with each request
    
    Image img;
    Fmri fmri;
    Map<String, List<DataSink>> flist = new HashMap<String, List<DataSink>>();
    File download_dir;
    
    public FileList(Image i, Fmri f) {
        img = i;
        fmri = f;
        download_dir = new File(new File(img.getMetaDirectory(), "download"), getPID());
    }
    
    public void add(DataSink a) {
        String h = a.getHash();
        List<DataSink> l;
        if ((l = flist.get(h)) == null) {
            l = new ArrayList<DataSink>();
            flist.put(h, l);
        }
        l.add(a);
    }
    
    public void download() throws IOException {
        if (flist.size() == 0) return;
        
        download_dir.mkdirs();
        
        StringBuffer reqbuf = new StringBuffer();
        int i = 0;
        int outfilenum = 0;
        int size = 0;
        Object args[] = { fmri.toString(), flist.size() };
        img.getLogger().log(Level.FINE, "downloadfiles", args);

        for (Iterator<String> aiter = flist.keySet().iterator(); aiter.hasNext(); i++)
        {
            String hash = aiter.next();
            if (reqbuf.length() > 0) reqbuf.append("&");
            reqbuf.append("File-Name-" + i + "=" + URLEncoder.encode(hash, "UTF-8"));
            DataSink fa = flist.get(hash).get(0);
            size += fa.getSize();
            if (size > max_bytes || !aiter.hasNext()) {
                // do a download
                HttpURLConnection uc = img.getRepositoryURLConnection("filelist/0", fmri);
                uc.setDoOutput(true);
                OutputStreamWriter osw = new OutputStreamWriter(uc.getOutputStream());
                osw.write(reqbuf.toString());
                osw.close();
                img.checkRepositoryConnection(uc);

                TarInputStream tis = new TarInputStream(new BufferedInputStream(uc.getInputStream()));

                TarEntry te;
                while ((te = tis.getNextEntry()) != null) {
                    hash = te.getName();
                    List<DataSink> fal = flist.get(hash);
                    fa = fal.get(0);
                    String outfilename = hash; 
                    img.getLogger().log(Level.FINER, "downloading", outfilename);
                    File gzipfile = new File(download_dir, outfilename);
                    fa.setGzipFile(gzipfile);
                    OutputStream fos = new BufferedOutputStream(new FileOutputStream(gzipfile));
                    tis.copyEntryContents(fos);
                    fos.close();
                    for (int j = 1; j < fal.size(); j++)
                    {
                        DataSink nfa = fal.get(j);
                        nfa.setGzipFile(gzipfile);
                    }
                }
                
                // reset for another batch of files
                size = 0; 
                i = 0;
                reqbuf = new StringBuffer();
            }
        }
    }
    
    /** 
     * Delete all of the temporary files created by this filelist
     * 
     * @throws java.io.IOException
     */
    public void cleanupDownload() throws IOException {
        img.getLogger().log(Level.FINEST, "deletingtemp");

        File files[] = download_dir.listFiles();
        if (files != null && files.length > 0) {
            for (File f : files) f.delete();
        }
        if (download_dir.exists()) download_dir.delete();
    }
    
    static String getPID() {
        String name = ManagementFactory.getRuntimeMXBean().getName();
        int i = 0; 
        while (i < name.length() && Character.isDigit(name.charAt(i))) i++;
        return i > 0 ? name.substring(0, i) : "0";
    }
}
