/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or updatetool/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 *
 * Contributor(s):
 *
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */
package com.sun.pkg.client;

import java.io.File;
import java.io.IOException;

/**
 * A <code>LinkAction</code> is an action that represents a symbolic link within 
 * the image.
 * 
 * @author trm
 */
class LinkAction extends Action {

    Image img;
    String path = "";
    String target = "";

    LinkAction(Image image, String tokens[]) 
    {
        super(8);
        img = image;
        for (int i = 1; i < tokens.length; i++) {
            if (tokens[i].startsWith("target=")) {
                target = tokens[i].substring(7);
            } else if (tokens[i].startsWith("path=")) {
                path = tokens[i].substring(5);
            }
        }
    }

    void install(Action orig) throws IOException {
        if (isPosix) {
            // delete any existing file at path - needed for Solaris 9
            File f = new File(img.getRootDirectory(), path);
            if (f.exists()) f.delete();
            String cmd[] = {"/bin/ln", "-fs", target, f.getCanonicalPath()};
            try {
                Process p = Runtime.getRuntime().exec(cmd, null, img.getRootDirectory());
                p.waitFor();
                if (p.exitValue() != 0) throw new Error("/bin/ln -fs failed");
            } catch (InterruptedException ie) {
            }
        }
    }

    @Override
    void remove() throws IOException { 
        File f = new File(img.getRootDirectory(), path);
        setPermissions(f, "0644");
        f.delete();
    }

    @Override
    String keyValue() 
    { 
        return path; 
    }

    @Override
    public String toString() {
        return "link: path=" + path;
    }

    boolean isDifferent(Action a) {
        if (!(a instanceof LinkAction)) return true;
        LinkAction la = (LinkAction)a;
        return !equals(a) ||
                !target.equals(la.target);
    }

}
