/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.maven2;

import com.sun.tools.xjc.maven2.XJC2TaskAdapter;
import java.io.File;
import java.util.Collection;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.selectors.FilenameSelector;

public class XJCMojo
extends AbstractMojo {
    protected File schemaDirectory;
    protected String[] includeSchemas;
    protected String[] excludeSchemas;
    protected String[] includeBindings;
    protected String[] excludeBindings;
    protected String generatePackage;
    protected File generateDirectory;
    protected boolean readOnly;
    protected boolean extension;
    protected File catalog;
    protected boolean removeOldOutput;
    protected boolean strict;
    protected boolean verbose;
    protected String args;
    protected MavenProject project;

    public void execute() throws MojoExecutionException {
        this.validateSettings();
        if (this.verbose) {
            this.logSettings();
        }
        if (this.generateDirectory != null && !this.generateDirectory.exists()) {
            this.generateDirectory.mkdirs();
        }
        XJC2TaskAdapter xjc2TaskAdapter = new XJC2TaskAdapter(this.getLog());
        xjc2TaskAdapter.options.verbose = this.verbose;
        String[] schemaFilenames = XJCMojo.getFiles(this.schemaDirectory, this.includeSchemas, this.excludeSchemas);
        String[] bindingsFilenames = XJCMojo.getFiles(this.schemaDirectory, this.includeBindings, this.excludeBindings);
        if (XJCMojo.isDefined(bindingsFilenames, 1)) {
            for (String name : bindingsFilenames) {
                xjc2TaskAdapter.setBinding(name);
            }
        }
        if (this.generatePackage != null) {
            xjc2TaskAdapter.setPackage(this.generatePackage);
        }
        if (this.generateDirectory != null) {
            xjc2TaskAdapter.setDestdir(this.generateDirectory);
        }
        xjc2TaskAdapter.setReadonly(this.readOnly);
        xjc2TaskAdapter.setExtension(this.extension);
        xjc2TaskAdapter.setStrict(this.strict);
        if (this.catalog != null) {
            xjc2TaskAdapter.setCatalog(this.catalog);
        }
        xjc2TaskAdapter.setRemoveOldOutput(this.removeOldOutput);
        if (this.project != null) {
            this.project.addCompileSourceRoot(this.generateDirectory.getPath());
        }
        FileSet dependencies = new FileSet();
        dependencies.setDir(this.schemaDirectory);
        if (XJCMojo.isDefined(bindingsFilenames, 1)) {
            for (String filename : bindingsFilenames) {
                if (this.verbose) {
                    this.getLog().debug((CharSequence)("Binding dependency: " + filename));
                }
                dependencies.addFilename(XJCMojo.createFilenameSelector(filename));
            }
        }
        xjc2TaskAdapter.addConfiguredDepends(dependencies);
        if (this.project != null) {
            FileSet pomDependencies = new FileSet();
            pomDependencies.setDir(this.project.getFile().getParentFile());
            if (this.verbose) {
                this.getLog().info((CharSequence)("pom dependency: " + this.project.getFile().getPath()));
            }
            pomDependencies.addFilename(XJCMojo.createFilenameSelector(this.project.getFile().getName()));
            xjc2TaskAdapter.addConfiguredDepends(pomDependencies);
        }
        FileSet products = new FileSet();
        File outDir = this.generateDirectory;
        if (this.generatePackage != null) {
            outDir = new File(outDir, this.generatePackage.replace('.', File.separatorChar));
        }
        products.setDir(outDir);
        products.setIncludes("**/*.java");
        xjc2TaskAdapter.addConfiguredProduces(products);
        if (this.args != null) {
            xjc2TaskAdapter.createArg().setLine(this.args);
        }
        for (String filename : schemaFilenames) {
            if (this.verbose) {
                this.getLog().info((CharSequence)("Schema dependency: " + filename));
            }
            xjc2TaskAdapter.setSchema(filename);
        }
        if (this.verbose) {
            this.getLog().info((CharSequence)"XJC compile");
        }
        xjc2TaskAdapter.execute();
    }

    private static FilenameSelector createFilenameSelector(String filename) {
        FilenameSelector selector = new FilenameSelector();
        selector.setName(filename);
        return selector;
    }

    private void validateSettings() throws MojoExecutionException {
        if (!XJCMojo.isDefined(this.schemaDirectory, 1)) {
            this.logSettings();
            throw new MojoExecutionException("The <schemaDirectory> setting must be defined.");
        }
        if (!XJCMojo.isDefined(this.includeSchemas, 1)) {
            if (this.verbose) {
                this.getLog().info((CharSequence)"The <includeSchemas> setting was not defined, assuming *.xsd.");
            }
            this.includeSchemas = new String[]{"*.xsd"};
        }
        if (!XJCMojo.isDefined(this.includeBindings, 1)) {
            if (this.verbose) {
                this.getLog().info((CharSequence)"The <includeBindings> setting was not defined, assuming *.xjb.");
            }
            this.includeBindings = new String[]{"*.xjb"};
        }
    }

    private static boolean isDefined(Object setting, int minimumLength) {
        boolean defined;
        boolean bl = defined = setting != null;
        defined = setting instanceof Object[] ? defined && ((Object[])setting).length >= minimumLength : (setting instanceof Collection ? defined && ((Collection)setting).size() >= minimumLength : defined && setting.toString().length() >= minimumLength);
        return defined;
    }

    private static String[] getFiles(File searchRootDirectory, String[] includePatterns, String[] excludePatterns) {
        DirectoryScanner directoryScanner = new DirectoryScanner();
        directoryScanner.setBasedir(searchRootDirectory);
        directoryScanner.setIncludes(includePatterns);
        directoryScanner.setExcludes(excludePatterns);
        directoryScanner.scan();
        String[] files = directoryScanner.getIncludedFiles();
        for (int i = 0; i < files.length; ++i) {
            files[i] = directoryScanner.getBasedir() + File.separator + files[i];
        }
        return files;
    }

    private void logSettings() {
        this.getLog().info((CharSequence)("schemaDirectory: " + this.schemaDirectory));
        this.getLog().info((CharSequence)("includeSchemas: " + XJCMojo.recursiveToString(this.includeSchemas)));
        this.getLog().info((CharSequence)("excludeSchemas: " + XJCMojo.recursiveToString(this.excludeSchemas)));
        this.getLog().info((CharSequence)("includeBindings: " + XJCMojo.recursiveToString(this.includeBindings)));
        this.getLog().info((CharSequence)("excludeBindings: " + XJCMojo.recursiveToString(this.excludeBindings)));
        this.getLog().info((CharSequence)("generatePackage: " + this.generatePackage));
        this.getLog().info((CharSequence)("generateDirectory: " + this.generateDirectory));
        this.getLog().info((CharSequence)("readOnly: " + this.readOnly));
        this.getLog().info((CharSequence)("extension: " + this.extension));
        this.getLog().info((CharSequence)("catalog: " + this.catalog));
        this.getLog().info((CharSequence)("removeOldOutput: " + this.removeOldOutput));
        this.getLog().info((CharSequence)("strict: " + this.strict));
        this.getLog().info((CharSequence)("verbose: " + this.verbose));
    }

    private static String recursiveToString(Object setting) {
        StringBuilder result = new StringBuilder();
        if (setting instanceof Collection) {
            Collection collection = (Collection)setting;
            setting = collection.toArray();
        }
        if (setting instanceof Object[]) {
            Object[] settingArray = setting;
            result.append('[');
            for (Object item : settingArray) {
                result.append(XJCMojo.recursiveToString(item));
                result.append(',');
            }
            result.setLength(result.length() - 1);
            result.append(']');
            return result.toString();
        }
        return setting == null ? "null" : setting.toString();
    }
}

