/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wts.tools.ant;

import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Command {
    private final Pattern from;
    private final String to;
    private final List<Pattern> excludes;

    public Command(Pattern from, String to) {
        this(from, to, Collections.emptyList());
    }

    public Command(Pattern from, String to, List<Pattern> excludes) {
        this.from = from;
        this.to = to;
        this.excludes = excludes;
    }

    public String replace(String input) {
        boolean result;
        Matcher m = this.from.matcher(input);
        if (!m.find()) {
            return input;
        }
        StringBuffer sb = new StringBuffer();
        do {
            boolean excluded = false;
            for (Pattern p : this.excludes) {
                if (!p.matcher(input.substring(m.start())).lookingAt()) continue;
                excluded = true;
                break;
            }
            if (excluded) {
                m.appendReplacement(sb, m.group());
                continue;
            }
            m.appendReplacement(sb, this.to);
        } while (result = m.find());
        m.appendTail(sb);
        return sb.toString();
    }
}

