/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wts.tools.ant;

import com.sun.wts.tools.ant.PackageRenameTask;
import com.sun.wts.tools.ant.RenamePattern;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;

public class PackageRenameMojo
extends AbstractMojo {
    protected MavenProject project;
    private File rootDir;
    private File srcDir;
    private Map patterns;
    private String excludes;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.patterns == null) {
            throw new MojoExecutionException("No replacement patterns given");
        }
        ArrayList<File> sources = new ArrayList<File>();
        if (this.srcDir != null && this.srcDir.exists() && this.srcDir.isDirectory()) {
            sources.add(this.srcDir);
        } else {
            for (String p : this.project.getCompileSourceRoots()) {
                sources.add(new File(p));
            }
        }
        for (File dir : sources) {
            PackageRenameTask task = new PackageRenameTask();
            task.setProject(this.createAntProject());
            task.setDestdir(this.rootDir);
            task.setSrcDir(dir);
            for (Map.Entry entry : this.patterns.entrySet()) {
                RenamePattern pattern = new RenamePattern((String)entry.getKey(), (String)entry.getValue());
                if (this.excludes != null) {
                    pattern.setExcludes(this.excludes);
                }
                task.addConfiguredPattern(pattern);
            }
            task.execute();
        }
        if (this.project != null) {
            this.project.addCompileSourceRoot(this.rootDir.getAbsolutePath());
        }
    }

    private Project createAntProject() {
        Project p = new Project();
        DefaultLogger antLogger = new DefaultLogger();
        antLogger.setOutputPrintStream(System.out);
        antLogger.setErrorPrintStream(System.err);
        antLogger.setMessageOutputLevel(this.getLog().isDebugEnabled() ? 4 : 2);
        p.addBuildListener((BuildListener)antLogger);
        return p;
    }
}

