/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wts.tools.ant;

import com.sun.wts.tools.ant.Command;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public class RenamePattern {
    private final String DIRECTORY_SEPARATOR = "/";
    private String from;
    private String to;
    private String directory;
    private final List<String> excludes = new ArrayList<String>();
    private static final Function[] FUNCTIONS = new Function[]{new Function(){

        @Override
        public String apply(String s) {
            return s;
        }

        @Override
        String applyExclude(String s) {
            return RenamePattern.cutEnd(s);
        }
    }, new Function(){

        @Override
        public String apply(String s) {
            return RenamePattern.cutEnd(s) + ';';
        }
    }, new Function(){

        @Override
        public String apply(String s) {
            return s.replace('.', '/');
        }
    }, new Function(){

        @Override
        public String apply(String s) {
            return s.replace('.', '\\');
        }
    }};

    public RenamePattern() {
    }

    public RenamePattern(String from, String to) {
        this.from = from;
        this.parseTo(to);
    }

    private void parseTo(String to) {
        if (!to.contains("/")) {
            this.to = to;
            return;
        }
        int separatorIndex = to.lastIndexOf("/");
        this.directory = to.substring(0, separatorIndex);
        this.to = to.substring(separatorIndex + 1, to.length());
    }

    String getFrom() {
        return this.from;
    }

    public void setFrom(String from) {
        this.from = from + '.';
    }

    String getTo() {
        return this.to;
    }

    public void setTo(String to) {
        this.to = to + '.';
    }

    public void setExcludes(String excludes) {
        StringTokenizer st = new StringTokenizer(excludes, ",");
        while (st.hasMoreTokens()) {
            this.excludes.add(st.nextToken().trim() + ".");
        }
    }

    private static String cutEnd(String s) {
        return s.substring(0, s.length() - 1);
    }

    public void addCommands(List<Command> commands) {
        for (Function f : FUNCTIONS) {
            ArrayList<Pattern> exclusions = new ArrayList<Pattern>();
            for (String exclude : this.excludes) {
                exclusions.add(Pattern.compile(f.applyExclude(exclude), 16));
            }
            commands.add(new Command(Pattern.compile(f.apply(this.from), 16), f.apply(this.to), exclusions));
        }
    }

    String convertPath(String relPath) {
        StringBuilder result = new StringBuilder();
        if (this.directory != null) {
            result.append(this.directory).append(File.separatorChar);
        }
        result.append(this.to.replace('.', File.separatorChar)).append(relPath.substring(this.from.length()));
        return result.toString();
    }

    boolean matches(String relPath) {
        String norm = relPath.replace('/', '.').replace('\\', '.');
        if (norm.startsWith(this.from)) {
            for (String e : this.excludes) {
                if (!norm.startsWith(e)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static abstract class Function {
        Function() {
        }

        abstract String apply(String var1);

        String applyExclude(String s) {
            return this.apply(s);
        }
    }
}

