/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.unmarshaller;

import com.sun.xml.bind.TypeRegistry;
import com.sun.xml.bind.unmarshaller.ContentHandlerEx;
import com.sun.xml.bind.unmarshaller.Messages;
import com.sun.xml.bind.unmarshaller.SAXUnmarshallerHandler;
import com.sun.xml.bind.unmarshaller.Tracer;
import com.sun.xml.bind.unmarshaller.UnmarshallableObject;
import com.sun.xml.bind.unmarshaller.UnmarshallerImpl;
import com.sun.xml.bind.unmarshaller.UnmarshallingContext;
import com.sun.xml.bind.unmarshaller.UnmarshallingEventHandler;
import com.sun.xml.bind.unmarshaller.UnreportedException;
import com.sun.xml.bind.util.AttributesImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.bind.JAXBException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.ValidationEvent;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SAXUnmarshallerHandlerImpl
implements SAXUnmarshallerHandler,
UnmarshallingContext {
    private boolean isUnmarshalInProgress = true;
    private final TypeRegistry typeRegistry;
    private UnmarshallableObject result;
    private UnmarshallingEventHandler[] handlers = new UnmarshallingEventHandler[16];
    private int[] mementos = new int[16];
    private int handlerLen = 0;
    private StringBuffer buffer = new StringBuffer();
    private String[] nsBind = new String[16];
    private int nsLen = 0;
    private int[] idxStack = new int[16];
    private int idxStackTop = 0;
    private final Stack attStack = new Stack();
    private Runnable[] patchers = null;
    private int patchersLen = 0;
    private Hashtable idmap = null;
    private Locator locator;
    private final UnmarshallerImpl parent;
    private boolean aborted = false;
    private Tracer tracer;

    public SAXUnmarshallerHandlerImpl(UnmarshallerImpl _parent, TypeRegistry _reg) {
        this.parent = _parent;
        this.typeRegistry = _reg;
        this.startPrefixMapping("", "");
    }

    @Override
    public TypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    @Override
    public void startDocument() throws SAXException {
        this.result = null;
        this.handlerLen = 0;
        this.patchers = null;
        this.patchersLen = 0;
        this.aborted = false;
        this.isUnmarshalInProgress = true;
        this.attStack.clear();
    }

    @Override
    public void endDocument() throws SAXException {
        this.runPatchers();
        this.isUnmarshalInProgress = false;
    }

    @Override
    public void startElement(String uri, String local, String qName, Attributes atts) throws SAXException {
        uri = uri.intern();
        local = local.intern();
        qName = qName.intern();
        try {
            if (this.result == null) {
                this.result = this.typeRegistry.createRootElement(uri, local);
                if (this.result == null) {
                    throw new SAXParseException(Messages.format("SAXUnmarshallerHandlerImpl.UnexpectedRootElement", qName), this.getLocator());
                }
                ContentHandlerEx unmarshaller = this.result.getUnmarshaller(this);
                this.pushContentHandler(unmarshaller, 0);
            }
            this.processText(true);
            this.getCurrentHandler().enterElement(uri, local, atts);
        }
        catch (UnreportedException e) {
            this.reportAndThrow(e);
        }
    }

    @Override
    public final void endElement(String uri, String local, String qname2) throws SAXException {
        uri = uri.intern();
        local = local.intern();
        qname2 = qname2.intern();
        try {
            this.processText(false);
            this.getCurrentHandler().leaveElement(uri, local);
        }
        catch (UnreportedException e) {
            this.reportAndThrow(e);
        }
    }

    public Object getResult() throws UnmarshalException {
        if (this.isUnmarshalInProgress) {
            throw new IllegalStateException();
        }
        if (!this.aborted) {
            return this.result;
        }
        throw new UnmarshalException((String)null);
    }

    @Override
    public void pushContentHandler(UnmarshallingEventHandler handler, int memento) {
        if (this.handlerLen == this.handlers.length) {
            UnmarshallingEventHandler[] h = new UnmarshallingEventHandler[this.handlerLen * 2];
            int[] m = new int[this.handlerLen * 2];
            System.arraycopy(this.handlers, 0, h, 0, this.handlerLen);
            System.arraycopy(this.mementos, 0, m, 0, this.handlerLen);
            this.handlers = h;
            this.mementos = m;
        }
        this.handlers[this.handlerLen] = handler;
        this.mementos[this.handlerLen] = memento;
        ++this.handlerLen;
    }

    @Override
    public void popContentHandler() throws UnreportedException {
        --this.handlerLen;
        this.handlers[this.handlerLen] = null;
        this.getCurrentHandler().leaveChild(this.mementos[this.handlerLen]);
    }

    @Override
    public ContentHandlerEx getCurrentHandler() {
        return (ContentHandlerEx)this.getCurrentEventHandler();
    }

    @Override
    public UnmarshallingEventHandler getCurrentEventHandler() {
        return this.handlers[this.handlerLen - 1];
    }

    protected void consumeText(String str, boolean ignorable) throws UnreportedException {
        if (this.getCurrentHandler().isListState()) {
            StringTokenizer tokens = new StringTokenizer(str);
            while (tokens.hasMoreTokens()) {
                this.getCurrentHandler().text(tokens.nextToken());
            }
        } else {
            if (ignorable && str.trim().length() == 0) {
                return;
            }
            this.getCurrentHandler().text(str);
        }
    }

    private void processText(boolean ignorable) throws UnreportedException {
        this.consumeText(this.buffer.toString(), ignorable);
        if (this.buffer.length() < 1024) {
            this.buffer.setLength(0);
        } else {
            this.buffer = new StringBuffer();
        }
    }

    @Override
    public final void characters(char[] buf, int start, int len) {
        this.buffer.append(buf, start, len);
    }

    @Override
    public final void ignorableWhitespace(char[] buf, int start, int len) {
        this.characters(buf, start, len);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) {
        if (this.nsBind.length == this.nsLen) {
            String[] n = new String[this.nsLen * 2];
            System.arraycopy(this.nsBind, 0, n, 0, this.nsLen);
            this.nsBind = n;
        }
        this.nsBind[this.nsLen++] = prefix;
        this.nsBind[this.nsLen++] = uri;
    }

    @Override
    public void endPrefixMapping(String prefix) {
        this.nsLen -= 2;
    }

    @Override
    public String resolveNamespacePrefix(String prefix) {
        if (prefix.equals("xml")) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        for (int i = this.idxStack[this.idxStackTop] - 2; i >= 0; i -= 2) {
            if (!prefix.equals(this.nsBind[i])) continue;
            return this.nsBind[i + 1];
        }
        return null;
    }

    public Iterator getPrefixes(String uri) {
        return Collections.unmodifiableList(this.getAllPrefixesInList(uri)).iterator();
    }

    private List getAllPrefixesInList(String uri) {
        ArrayList<String> a = new ArrayList<String>();
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            a.add("xml");
            return a;
        }
        if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            a.add("xmlns");
            return a;
        }
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        for (int i = this.nsLen - 2; i >= 0; i -= 2) {
            if (!uri.equals(this.nsBind[i + 1]) || !this.getNamespaceURI(this.nsBind[i]).equals(this.nsBind[i + 1])) continue;
            a.add(this.nsBind[i]);
        }
        return a;
    }

    @Override
    public String getPrefix(String uri) {
        if (uri.equals("http://www.w3.org/XML/1998/namespace")) {
            return "xml";
        }
        if (uri.equals("http://www.w3.org/2000/xmlns/")) {
            return "xmlns";
        }
        if (uri == null) {
            throw new IllegalArgumentException();
        }
        for (int i = this.idxStack[this.idxStackTop] - 2; i >= 0; i -= 2) {
            if (!uri.equals(this.nsBind[i + 1]) || !this.getNamespaceURI(this.nsBind[i]).equals(this.nsBind[i + 1])) continue;
            return this.nsBind[i];
        }
        return null;
    }

    @Override
    public String getNamespaceURI(String prefix) {
        if (prefix.equals("xmlns")) {
            return "http://www.w3.org/2000/xmlns/";
        }
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        return this.resolveNamespacePrefix(prefix);
    }

    @Override
    public void pushAttributes(Attributes atts) {
        String v;
        AttributesImpl a = new AttributesImpl();
        for (int i = 0; i < atts.getLength(); ++i) {
            a.addAttribute(atts.getURI(i).intern(), atts.getLocalName(i).intern(), atts.getQName(i).intern(), atts.getType(i), atts.getValue(i));
        }
        int idx = a.getIndex("http://www.w3.org/2001/XMLSchema-instance", "nil");
        if (idx != -1 && ((v = a.getValue(idx).trim()).equals("false") || v.equals("0"))) {
            a.removeAttribute(idx);
        }
        this.attStack.push(a);
        if (++this.idxStackTop == this.idxStack.length) {
            int[] newBuf = new int[this.idxStack.length * 2];
            System.arraycopy(this.idxStack, 0, newBuf, 0, this.idxStack.length);
            this.idxStack = newBuf;
        }
        this.idxStack[this.idxStackTop] = this.nsLen;
    }

    @Override
    public void popAttributes() {
        this.attStack.pop();
        --this.idxStackTop;
    }

    @Override
    public Attributes getUnconsumedAttributes() {
        return (Attributes)this.attStack.peek();
    }

    @Override
    public int getAttribute(String uri, String local) {
        if (this.attStack.isEmpty()) {
            return -1;
        }
        Attributes a = (Attributes)this.attStack.peek();
        return a.getIndex(uri, local);
    }

    @Override
    public void consumeAttribute(int idx) throws UnreportedException {
        AttributesImpl a = (AttributesImpl)this.attStack.peek();
        String uri = a.getURI(idx).intern();
        String local = a.getLocalName(idx).intern();
        String value = a.getValue(idx).intern();
        a.removeAttribute(idx);
        this.getCurrentHandler().enterAttribute(uri, local);
        this.consumeText(value, false);
        this.getCurrentHandler().leaveAttribute(uri, local);
    }

    @Override
    public void addPatcher(Runnable job) {
        if (this.patchers == null) {
            this.patchers = new Runnable[32];
        }
        if (this.patchers.length == this.patchersLen) {
            Runnable[] buf = new Runnable[this.patchersLen * 2];
            System.arraycopy(this.patchers, 0, buf, 0, this.patchersLen);
            this.patchers = buf;
        }
        this.patchers[this.patchersLen++] = job;
    }

    private void runPatchers() {
        if (this.patchers != null) {
            for (int i = 0; i < this.patchersLen; ++i) {
                this.patchers[i].run();
            }
        }
    }

    @Override
    public String addToIdTable(String id) {
        if (this.idmap == null) {
            this.idmap = new Hashtable();
        }
        this.idmap.put(id, this.getCurrentHandler().owner());
        return id;
    }

    @Override
    public UnmarshallableObject getObjectFromId(String id) {
        if (this.idmap == null) {
            return null;
        }
        return (UnmarshallableObject)this.idmap.get(id);
    }

    @Override
    public void skippedEntity(String name) {
    }

    @Override
    public void processingInstruction(String target, String data) {
    }

    @Override
    public void setDocumentLocator(Locator loc) {
        this.locator = loc;
    }

    @Override
    public Locator getLocator() {
        return this.locator;
    }

    public boolean handleEvent(ValidationEvent event) {
        try {
            boolean recover = this.parent.getEventHandler().handleEvent(event);
            if (!recover) {
                this.aborted = true;
            }
            return recover;
        }
        catch (JAXBException e) {
            return false;
        }
        catch (RuntimeException re) {
            return false;
        }
    }

    public void reportAndThrow(UnreportedException e) throws SAXException {
        this.handleEvent(e.createValidationEvent());
        throw new SAXException((Exception)e.createUnmarshalException());
    }

    @Override
    public String getBaseUri() {
        return null;
    }

    @Override
    public boolean isUnparsedEntity(String s) {
        return true;
    }

    @Override
    public boolean isNotation(String s) {
        return true;
    }

    public void setTracer(Tracer t) {
        this.tracer = t;
    }

    @Override
    public Tracer getTracer() {
        if (this.tracer == null) {
            this.tracer = new Tracer.Standard();
        }
        return this.tracer;
    }
}

