/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.unmarshaller;

import java.io.PrintStream;

public class Tracer {
    public void onEnterElement(String uri, String local) {
    }

    public void onEnterAttribute(String uri, String local) {
    }

    public void onLeaveElement(String uri, String local) {
    }

    public void onLeaveAttribute(String uri, String local) {
    }

    public void onText(String text) {
    }

    public void onConvertValue(String text, String field) {
    }

    public void onSpawnChild(String childType, String field) {
    }

    public void onSpawnSuper(String superType) {
    }

    public void onSpawnWildcard() {
    }

    public void onRevertToParent() {
    }

    public void nextState(int n) {
    }

    public void suspend() {
    }

    public static class Standard
    extends Tracer {
        private int indent = 0;
        private PrintStream out = System.out;

        private void printIndent() {
            for (int i = 0; i < this.indent; ++i) {
                this.out.print(' ');
            }
        }

        @Override
        public void onEnterElement(String uri, String local) {
            this.printEvent("<", uri, local, ">");
            ++this.indent;
        }

        @Override
        public void onEnterAttribute(String uri, String local) {
            this.printEvent("@", uri, local, "");
            ++this.indent;
        }

        @Override
        public void onLeaveElement(String uri, String local) {
            --this.indent;
            this.printEvent("</", uri, local, ">");
        }

        @Override
        public void onLeaveAttribute(String uri, String local) {
            --this.indent;
            this.printEvent("/@", uri, local, "");
        }

        @Override
        public void onText(String text) {
            this.printIndent();
            this.out.print("text(" + text.trim() + ") ");
        }

        private void printEvent(String prefix, String uri, String local, String suffix) {
            this.printIndent();
            this.out.print(prefix + '(' + uri + ',' + local + ')' + suffix + ' ');
        }

        @Override
        public void onConvertValue(String text, String field) {
            this.out.print("to " + field);
        }

        @Override
        public void onSpawnChild(String childType, String field) {
            this.indent += 3;
            this.out.print("spawn a child field:" + field + " type:" + childType);
        }

        @Override
        public void onSpawnSuper(String superType) {
            this.indent += 3;
            this.out.print("spawn a super class unmarshaller :" + superType);
        }

        @Override
        public void onRevertToParent() {
            this.indent -= 3;
            this.out.print("revert to parent");
        }

        @Override
        public void nextState(int n) {
            this.out.println(" -> #" + n);
        }

        @Override
        public void suspend() {
            this.out.println();
        }
    }
}

