/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 * 
 * Copyright 1997-2007 Sun Microsystems, Inc. All rights reserved.
 * 
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License. You can obtain
 * a copy of the License at https://glassfish.dev.java.net/public/CDDL+GPL.html
 * or glassfish/bootstrap/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 * 
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at glassfish/bootstrap/legal/LICENSE.txt.
 * Sun designates this particular file as subject to the "Classpath" exception
 * as provided by Sun in the GPL Version 2 section of the License file that
 * accompanied this code.  If applicable, add the following below the License
 * Header, with the fields enclosed by brackets [] replaced by your own
 * identifying information: "Portions Copyrighted [year]
 * [name of copyright owner]"
 * 
 * Contributor(s):
 * 
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

package com.sun.java_cup.internal;

/** This class represents a transition in an LALR viable prefix recognition 
 *  machine.  Transitions can be under terminals for non-terminals.  They are
 *  internally linked together into singly linked lists containing all the 
 *  transitions out of a single state via the _next field.
 *
 * @see     com.sun.java_cup.internal.lalr_state
 * @version last updated: 11/25/95
 * @author  Scott Hudson
 *
 */
public class lalr_transition {

  /*-----------------------------------------------------------*/
  /*--- Constructor(s) ----------------------------------------*/
  /*-----------------------------------------------------------*/

  /** Full constructor.
   * @param on_sym  symbol we are transitioning on.
   * @param to_st   state we transition to.
   * @param nxt     next transition in linked list.
   */
  public lalr_transition(symbol on_sym, lalr_state to_st, lalr_transition nxt)
    throws internal_error
    {
      /* sanity checks */
      if (on_sym == null)
	throw new internal_error("Attempt to create transition on null symbol");
      if (to_st == null)
	throw new internal_error("Attempt to create transition to null state");

      /* initialize */
      _on_symbol = on_sym;
      _to_state  = to_st;
      _next      = nxt;
    }

  /*. . . . . . . . . . . . . . . . . . . . . . . . . . . . . .*/

  /** Constructor with null next. 
   * @param on_sym  symbol we are transitioning on.
   * @param to_st   state we transition to.
   */
  public lalr_transition(symbol on_sym, lalr_state to_st) throws internal_error
    {
      this(on_sym, to_st, null);
    }

  /*-----------------------------------------------------------*/
  /*--- (Access to) Instance Variables ------------------------*/
  /*-----------------------------------------------------------*/

  /** The symbol we make the transition on. */
  protected symbol _on_symbol;

  /** The symbol we make the transition on. */
  public symbol on_symbol() {return _on_symbol;}

  /*. . . . . . . . . . . . . . . . . . . . . . . . . . . . . .*/

  /** The state we transition to. */
  protected lalr_state _to_state;

  /** The state we transition to. */
  public lalr_state to_state() {return _to_state;}

  /*. . . . . . . . . . . . . . . . . . . . . . . . . . . . . .*/

  /** Next transition in linked list of transitions out of a state */
  protected lalr_transition _next;

  /** Next transition in linked list of transitions out of a state */
  public lalr_transition next() {return _next;}

  /*-----------------------------------------------------------*/
  /*--- General Methods ---------------------------------------*/
  /*-----------------------------------------------------------*/

  /** Convert to a string. */
  public String toString()
    {
      String result;

      result = "transition on " + on_symbol().name() + " to state [";
      result += _to_state.index();
      result += "]";

      return result;
    }

  /*-----------------------------------------------------------*/
}
