/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 *
 *
 * This file incorporates work covered by the following copyright and
 * permission notice:
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * $Id: ClassGenerator.java,v 1.10 2010-11-01 04:34:19 joehw Exp $
 */
package com.sun.org.apache.xalan.internal.xsltc.compiler.util;

import com.sun.org.apache.bcel.internal.generic.ALOAD;
import com.sun.org.apache.bcel.internal.generic.ClassGen;
import com.sun.org.apache.bcel.internal.generic.Instruction;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Constants;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Parser;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Stylesheet;

/**
 * The class that implements any class that inherits from 
 * <tt>AbstractTranslet</tt>, i.e. any translet. Methods in this 
 * class may be of the following kinds: 
 *
 * 1. Main method: applyTemplates, implemented by intances of 
 * <tt>MethodGenerator</tt>.
 *
 * 2. Named methods: for named templates, implemented by instances 
 * of <tt>NamedMethodGenerator</tt>.
 *
 * 3. Rt methods: for result tree fragments, implemented by 
 * instances of <tt>RtMethodGenerator</tt>.
 * @author Jacek Ambroziak
 * @author Santiago Pericas-Geertsen
 */
public class ClassGenerator extends ClassGen {
    protected final static int TRANSLET_INDEX = 0;
    protected static int INVALID_INDEX  = -1;

    private Stylesheet _stylesheet;
    private final Parser _parser;		// --> can be moved to XSLT
    // a  single instance cached here
    private final Instruction _aloadTranslet;
    private final String _domClass;
    private final String _domClassSig;
    private final String _applyTemplatesSig;
	private final String _applyTemplatesSigForImport;
    
    public ClassGenerator(String class_name, String super_class_name,
			  String file_name,
			  int access_flags, String[] interfaces,
			  Stylesheet stylesheet) {
	super(class_name, super_class_name, file_name,
	      access_flags, interfaces);
	_stylesheet = stylesheet;
	_parser = stylesheet.getParser();
	_aloadTranslet = new ALOAD(TRANSLET_INDEX);
	
	if (stylesheet.isMultiDocument()) {
	    _domClass = "com.sun.org.apache.xalan.internal.xsltc.dom.MultiDOM";
	    _domClassSig = "Lcom/sun/org/apache/xalan/internal/xsltc/dom/MultiDOM;";
	}
	else {
	    _domClass = "com.sun.org.apache.xalan.internal.xsltc.dom.DOMAdapter";
	    _domClassSig = "Lcom/sun/org/apache/xalan/internal/xsltc/dom/DOMAdapter;";
	}
	_applyTemplatesSig = "(" 
	    + Constants.DOM_INTF_SIG
	    + Constants.NODE_ITERATOR_SIG
	    + Constants.TRANSLET_OUTPUT_SIG
	    + ")V";

    _applyTemplatesSigForImport = "(" 
        + Constants.DOM_INTF_SIG
        + Constants.NODE_ITERATOR_SIG
        + Constants.TRANSLET_OUTPUT_SIG
        + Constants.NODE_FIELD_SIG
        + ")V";  
    }

    public final Parser getParser() {
	return _parser;
    }

    public final Stylesheet getStylesheet() {
	return _stylesheet;
    }

    /**
     * Pretend this is the stylesheet class. Useful when compiling 
     * references to global variables inside a predicate.
     */
    public final String getClassName() {
	return _stylesheet.getClassName();
    }

    public Instruction loadTranslet() {
	return _aloadTranslet;
    }

    public final String getDOMClass() {
	return _domClass;
    }

    public final String getDOMClassSig() {
	return _domClassSig;
    }

    public final String getApplyTemplatesSig() {
	return _applyTemplatesSig;
    }
    
    public final String getApplyTemplatesSigForImport() {
    return _applyTemplatesSigForImport;
    }

    /**
     * Returns <tt>true</tt> or <tt>false</tt> depending on whether
     * this class inherits from <tt>AbstractTranslet</tt> or not.
     */
    public boolean isExternal() {
	return false;
    }
}
