/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 *
 *
 * This file incorporates work covered by the following copyright and
 * permission notice:
 *
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * $Id: WriterOutputBuffer.java,v 1.10 2010-11-01 04:34:29 joehw Exp $
 */
package com.sun.org.apache.xalan.internal.xsltc.runtime.output;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;

/**
 * @author Santiago Pericas-Geertsen
 */
class WriterOutputBuffer implements OutputBuffer {
    private static final int KB = 1024;
    private static int BUFFER_SIZE = 4 * KB;

    static {
	// Set a larger buffer size for Solaris
	final String osName = System.getProperty("os.name");
	if (osName.equalsIgnoreCase("solaris")) {
	    BUFFER_SIZE = 32 * KB;
	}
    }

    private Writer _writer;

    /**
     * Initializes a WriterOutputBuffer by creating an instance of a 
     * BufferedWriter. The size of the buffer in this writer may have 
     * a significant impact on throughput. Solaris prefers a larger
     * buffer, while Linux works better with a smaller one.
     */
    public WriterOutputBuffer(Writer writer) {
	_writer = new BufferedWriter(writer, BUFFER_SIZE);
    }

    public String close() {
	try {
	    _writer.flush();
	}
	catch (IOException e) {
	    throw new RuntimeException(e.toString());
	}
	return "";
    }

    public OutputBuffer append(String s) {
	try {
	    _writer.write(s);
	}
	catch (IOException e) {
	    throw new RuntimeException(e.toString());
	}
	return this;
    }

    public OutputBuffer append(char[] s, int from, int to) {
	try {
	    _writer.write(s, from, to);
	}
	catch (IOException e) {
	    throw new RuntimeException(e.toString());
	}
	return this;
    }

    public OutputBuffer append(char ch) {
	try {
	    _writer.write(ch);
	}
	catch (IOException e) {
	    throw new RuntimeException(e.toString());
	}
	return this;
    }
}


