/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 1997-2010 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://glassfish.dev.java.net/public/CDDL+GPL_1_1.html
 * or packager/legal/LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at packager/legal/LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

/*
 * $Id: SAX2StAXBaseWriter.java,v 1.7 2010-11-01 04:34:32 joehw Exp $
 * %W% %E%
 */
package com.sun.org.apache.xalan.internal.xsltc.trax;

import java.util.Vector;

import javax.xml.stream.Location;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;

import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;


public abstract class SAX2StAXBaseWriter extends DefaultHandler
		implements
			LexicalHandler {


	protected boolean isCDATA;

	protected StringBuffer CDATABuffer;

	protected Vector namespaces;

	protected Locator docLocator;

	protected XMLReporter reporter;

	public SAX2StAXBaseWriter() {
	}

	public SAX2StAXBaseWriter(XMLReporter reporter) {
		this.reporter = reporter;
	}

	public void setXMLReporter(XMLReporter reporter) {
		this.reporter = reporter;
	}

	public void setDocumentLocator(Locator locator) {
		this.docLocator = locator;
	}


	public Location getCurrentLocation() {
		if (docLocator != null) {
			return new SAXLocation(docLocator);
		} else {
			return null;
		}

	}

	public void error(SAXParseException e) throws SAXException {
		reportException("ERROR", e);
	}

	public void fatalError(SAXParseException e) throws SAXException {
		reportException("FATAL", e);
	}

	public void warning(SAXParseException e) throws SAXException {
		reportException("WARNING", e);
	}

	public void startDocument() throws SAXException {
                    namespaces = new Vector(2);
	}

	public void endDocument() throws SAXException {
		namespaces = null;
	}

	public void startElement(String uri, String localName, String qName,
			Attributes attributes) throws SAXException {
			namespaces = null;
	}

	public void endElement(String uri, String localName, String qName)
			throws SAXException {
		namespaces = null;
	}

	public void startPrefixMapping(String prefix, String uri)
			throws SAXException {

		if (prefix == null) {
			prefix = "";
		} else if (prefix.equals("xml")) {
			return;
		}

		if (namespaces == null) {
        	    namespaces = new Vector(2);
        	}
                namespaces.addElement(prefix);
                namespaces.addElement(uri);
        }
            

	public void endPrefixMapping(String prefix) throws SAXException {
	}

	public void startCDATA() throws SAXException {
		isCDATA = true;
		if (CDATABuffer == null) {
			CDATABuffer = new StringBuffer();
		} else {
			CDATABuffer.setLength(0);
		}
	}

	public void characters(char[] ch, int start, int length)
			throws SAXException {
		if (isCDATA) {
			CDATABuffer.append(ch, start, length);
		}
	}

	public void endCDATA() throws SAXException {
		isCDATA = false;
		CDATABuffer.setLength(0);
	}

	public void comment(char[] ch, int start, int length) throws SAXException {
	}

	public void endDTD() throws SAXException {
	}

	public void endEntity(String name) throws SAXException {
	}

	public void startDTD(String name, String publicId, String systemId)
			throws SAXException {
	}

	public void startEntity(String name) throws SAXException {
	}

	/**
	 * Used to report a {@link SAXException}to the {@link XMLReporter}
	 * registered with this handler.
	 */
	protected void reportException(String type, SAXException e)
			throws SAXException {

		if (reporter != null) {
			try {
				reporter.report(e.getMessage(), type, e, getCurrentLocation());
			} catch (XMLStreamException e1) {
				throw new SAXException(e1);
			}
		}
	}

	/**
	 * Parses an XML qualified name, and places the resulting prefix and local
	 * name in the provided String array.
	 * 
	 * @param qName The qualified name to parse.
	 * @param results An array where parse results will be placed. The prefix
	 *            will be placed at <code>results[0]</code>, and the local
	 *            part at <code>results[1]</code>
	 */
	public static final void parseQName(String qName, String[] results) {

		String prefix, local;
		int idx = qName.indexOf(':');
		if (idx >= 0) {
			prefix = qName.substring(0, idx);
			local = qName.substring(idx + 1);
		} else {
			prefix = "";
			local = qName;
		}
		results[0] = prefix;
		results[1] = local;
	}

	/**
	 * {@Link Location}implementation used to expose details from a SAX
	 * {@link Locator}.
	 * 
	 * @author christian
	 * @version $Revision: 1.7 $
	 */
	private static final class SAXLocation implements Location {

		private int lineNumber;
		private int columnNumber;
		private String publicId;
		private String systemId;
		private SAXLocation(Locator locator) {
			lineNumber = locator.getLineNumber();
			columnNumber = locator.getColumnNumber();
			publicId = locator.getPublicId();
			systemId = locator.getSystemId();
		}

		public int getLineNumber() {
			return lineNumber;
		}

		public int getColumnNumber() {
			return columnNumber;
		}

		public int getCharacterOffset() {
			return -1;
		}

		public String getPublicId() {
			return publicId;
		}

		public String getSystemId() {
			return systemId;
		}
	}
}
