/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xerces.internal.jaxp.validation;

import com.sun.org.apache.xerces.internal.impl.XMLEntityManager;
import com.sun.org.apache.xerces.internal.impl.XMLErrorReporter;
import com.sun.org.apache.xerces.internal.impl.validation.ValidationManager;
import com.sun.org.apache.xerces.internal.impl.xs.XMLSchemaValidator;
import com.sun.org.apache.xerces.internal.impl.xs.XSMessageFormatter;
import com.sun.org.apache.xerces.internal.jaxp.validation.DraconianErrorHandler;
import com.sun.org.apache.xerces.internal.jaxp.validation.XSGrammarPoolContainer;
import com.sun.org.apache.xerces.internal.util.DOMEntityResolverWrapper;
import com.sun.org.apache.xerces.internal.util.ErrorHandlerWrapper;
import com.sun.org.apache.xerces.internal.util.NamespaceSupport;
import com.sun.org.apache.xerces.internal.util.ParserConfigurationSettings;
import com.sun.org.apache.xerces.internal.util.SecurityManager;
import com.sun.org.apache.xerces.internal.util.SymbolTable;
import com.sun.org.apache.xerces.internal.xni.NamespaceContext;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponent;
import com.sun.org.apache.xerces.internal.xni.parser.XMLComponentManager;
import com.sun.org.apache.xerces.internal.xni.parser.XMLConfigurationException;
import java.util.HashMap;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;

final class XMLSchemaValidatorComponentManager
extends ParserConfigurationSettings
implements XMLComponentManager {
    private static final String SCHEMA_VALIDATION = "http://apache.org/xml/features/validation/schema";
    private static final String VALIDATION = "http://xml.org/sax/features/validation";
    private static final String USE_GRAMMAR_POOL_ONLY = "http://apache.org/xml/features/internal/validation/schema/use-grammar-pool-only";
    private static final String ENTITY_MANAGER = "http://apache.org/xml/properties/internal/entity-manager";
    private static final String ENTITY_RESOLVER = "http://apache.org/xml/properties/internal/entity-resolver";
    private static final String ERROR_HANDLER = "http://apache.org/xml/properties/internal/error-handler";
    private static final String ERROR_REPORTER = "http://apache.org/xml/properties/internal/error-reporter";
    private static final String NAMESPACE_CONTEXT = "http://apache.org/xml/properties/internal/namespace-context";
    private static final String SCHEMA_VALIDATOR = "http://apache.org/xml/properties/internal/validator/schema";
    private static final String SECURITY_MANAGER = "http://apache.org/xml/properties/security-manager";
    private static final String SYMBOL_TABLE = "http://apache.org/xml/properties/internal/symbol-table";
    private static final String VALIDATION_MANAGER = "http://apache.org/xml/properties/internal/validation-manager";
    private static final String XMLGRAMMAR_POOL = "http://apache.org/xml/properties/internal/grammar-pool";
    private boolean fConfigUpdated = true;
    private boolean fUseGrammarPoolOnly;
    private final HashMap fComponents = new HashMap();
    private XMLEntityManager fEntityManager = new XMLEntityManager();
    private XMLErrorReporter fErrorReporter;
    private NamespaceContext fNamespaceContext;
    private XMLSchemaValidator fSchemaValidator;
    private ValidationManager fValidationManager;
    private ErrorHandler fErrorHandler = null;
    private LSResourceResolver fResourceResolver = null;

    public XMLSchemaValidatorComponentManager(XSGrammarPoolContainer grammarContainer) {
        this.fComponents.put(ENTITY_MANAGER, this.fEntityManager);
        this.fErrorReporter = new XMLErrorReporter();
        this.fComponents.put(ERROR_REPORTER, this.fErrorReporter);
        this.fNamespaceContext = new NamespaceSupport();
        this.fComponents.put(NAMESPACE_CONTEXT, this.fNamespaceContext);
        this.fSchemaValidator = new XMLSchemaValidator();
        this.fComponents.put(SCHEMA_VALIDATOR, this.fSchemaValidator);
        this.fValidationManager = new ValidationManager();
        this.fComponents.put(VALIDATION_MANAGER, this.fValidationManager);
        this.fComponents.put(ENTITY_RESOLVER, null);
        this.fComponents.put(ERROR_HANDLER, null);
        this.fComponents.put(SECURITY_MANAGER, null);
        this.fComponents.put(SYMBOL_TABLE, new SymbolTable());
        this.fComponents.put(XMLGRAMMAR_POOL, grammarContainer.getGrammarPool());
        this.fUseGrammarPoolOnly = grammarContainer.isFullyComposed();
        this.fErrorReporter.putMessageFormatter("http://www.w3.org/TR/xml-schema-1", new XSMessageFormatter());
        this.addRecognizedParamsAndSetDefaults(this.fEntityManager);
        this.addRecognizedParamsAndSetDefaults(this.fErrorReporter);
        this.addRecognizedParamsAndSetDefaults(this.fSchemaValidator);
    }

    @Override
    public boolean getFeature(String featureId) throws XMLConfigurationException {
        if ("http://apache.org/xml/features/internal/parser-settings".equals(featureId)) {
            return this.fConfigUpdated;
        }
        if (VALIDATION.equals(featureId) || SCHEMA_VALIDATION.equals(featureId)) {
            return true;
        }
        if (USE_GRAMMAR_POOL_ONLY.equals(featureId)) {
            return this.fUseGrammarPoolOnly;
        }
        if ("http://javax.xml.XMLConstants/feature/secure-processing".equals(featureId)) {
            return this.getProperty(SECURITY_MANAGER) != null;
        }
        return super.getFeature(featureId);
    }

    @Override
    public void setFeature(String featureId, boolean value) throws XMLConfigurationException {
        if ("http://apache.org/xml/features/internal/parser-settings".equals(featureId)) {
            throw new XMLConfigurationException(1, featureId);
        }
        if (!value && (VALIDATION.equals(featureId) || SCHEMA_VALIDATION.equals(featureId))) {
            throw new XMLConfigurationException(1, featureId);
        }
        if (USE_GRAMMAR_POOL_ONLY.equals(featureId) && value != this.fUseGrammarPoolOnly) {
            throw new XMLConfigurationException(1, featureId);
        }
        this.fConfigUpdated = true;
        if ("http://javax.xml.XMLConstants/feature/secure-processing".equals(featureId)) {
            this.setProperty(SECURITY_MANAGER, value ? new SecurityManager() : null);
            return;
        }
        this.fEntityManager.setFeature(featureId, value);
        this.fErrorReporter.setFeature(featureId, value);
        this.fSchemaValidator.setFeature(featureId, value);
        super.setFeature(featureId, value);
    }

    @Override
    public Object getProperty(String propertyId) throws XMLConfigurationException {
        Object component = this.fComponents.get(propertyId);
        if (component != null) {
            return component;
        }
        if (this.fComponents.containsKey(propertyId)) {
            return null;
        }
        return super.getProperty(propertyId);
    }

    @Override
    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        if (ENTITY_MANAGER.equals(propertyId) || ERROR_REPORTER.equals(propertyId) || NAMESPACE_CONTEXT.equals(propertyId) || SCHEMA_VALIDATOR.equals(propertyId) || SYMBOL_TABLE.equals(propertyId) || VALIDATION_MANAGER.equals(propertyId) || XMLGRAMMAR_POOL.equals(propertyId)) {
            throw new XMLConfigurationException(1, propertyId);
        }
        this.fConfigUpdated = true;
        this.fEntityManager.setProperty(propertyId, value);
        this.fErrorReporter.setProperty(propertyId, value);
        this.fSchemaValidator.setProperty(propertyId, value);
        if (ENTITY_RESOLVER.equals(propertyId) || ERROR_HANDLER.equals(propertyId) || SECURITY_MANAGER.equals(propertyId)) {
            this.fComponents.put(propertyId, value);
            return;
        }
        super.setProperty(propertyId, value);
    }

    public void addRecognizedParamsAndSetDefaults(XMLComponent component) {
        String[] recognizedFeatures = component.getRecognizedFeatures();
        this.addRecognizedFeatures(recognizedFeatures);
        String[] recognizedProperties = component.getRecognizedProperties();
        this.addRecognizedProperties(recognizedProperties);
        this.setFeatureDefaults(component, recognizedFeatures);
        this.setPropertyDefaults(component, recognizedProperties);
    }

    public void reset() throws XNIException {
        this.fNamespaceContext.reset();
        this.fValidationManager.reset();
        this.fEntityManager.reset(this);
        this.fErrorReporter.reset(this);
        this.fSchemaValidator.reset(this);
        this.fConfigUpdated = false;
    }

    void setErrorHandler(ErrorHandler errorHandler) {
        this.fErrorHandler = errorHandler;
        this.setProperty(ERROR_HANDLER, errorHandler != null ? new ErrorHandlerWrapper(errorHandler) : new ErrorHandlerWrapper(DraconianErrorHandler.getInstance()));
    }

    ErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    void setResourceResolver(LSResourceResolver resourceResolver) {
        this.fResourceResolver = resourceResolver;
        this.setProperty(ENTITY_RESOLVER, new DOMEntityResolverWrapper(resourceResolver));
    }

    public LSResourceResolver getResourceResolver() {
        return this.fResourceResolver;
    }

    void restoreInitialState() {
        this.fConfigUpdated = true;
        this.fFeatures.clear();
        this.fProperties.clear();
        this.fComponents.put(ENTITY_RESOLVER, null);
        this.fComponents.put(ERROR_HANDLER, null);
        this.setFeatureDefaults(this.fEntityManager, this.fEntityManager.getRecognizedFeatures());
        this.setPropertyDefaults(this.fEntityManager, this.fEntityManager.getRecognizedProperties());
        this.setFeatureDefaults(this.fErrorReporter, this.fErrorReporter.getRecognizedFeatures());
        this.setPropertyDefaults(this.fErrorReporter, this.fErrorReporter.getRecognizedProperties());
        this.setFeatureDefaults(this.fSchemaValidator, this.fSchemaValidator.getRecognizedFeatures());
        this.setPropertyDefaults(this.fSchemaValidator, this.fSchemaValidator.getRecognizedProperties());
    }

    private void setFeatureDefaults(XMLComponent component, String[] recognizedFeatures) {
        if (recognizedFeatures != null) {
            for (int i = 0; i < recognizedFeatures.length; ++i) {
                String featureId = recognizedFeatures[i];
                Boolean state = component.getFeatureDefault(featureId);
                if (state == null || this.fFeatures.containsKey(featureId)) continue;
                this.fFeatures.put(featureId, state);
                this.fConfigUpdated = true;
            }
        }
    }

    private void setPropertyDefaults(XMLComponent component, String[] recognizedProperties) {
        if (recognizedProperties != null) {
            for (int i = 0; i < recognizedProperties.length; ++i) {
                String propertyId = recognizedProperties[i];
                Object value = component.getPropertyDefault(propertyId);
                if (value == null || this.fProperties.containsKey(propertyId)) continue;
                this.fProperties.put(propertyId, value);
                this.fConfigUpdated = true;
            }
        }
    }
}

