/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi.infomodel;

import com.sun.xml.registry.uddi.infomodel.LocalizedStringImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.xml.registry.JAXRException;
import javax.xml.registry.UnexpectedObjectException;
import javax.xml.registry.infomodel.InternationalString;
import javax.xml.registry.infomodel.LocalizedString;

public class InternationalStringImpl
implements InternationalString,
Serializable {
    static String DEFAULT_CHARSET = "UTF-8";
    private HashMap strings = new HashMap();

    public InternationalStringImpl() {
    }

    public InternationalStringImpl(LocalizedString lString) throws JAXRException {
        this();
        String key = this.makeKey(lString.getCharsetName(), lString.getLocale());
        this.strings.put(key, lString);
    }

    public InternationalStringImpl(Locale locale, String value) {
        this();
        String key = this.makeKey(DEFAULT_CHARSET, locale);
        this.strings.put(key, new LocalizedStringImpl(locale, value));
    }

    public InternationalStringImpl(String value) {
        this(Locale.getDefault(), value);
    }

    public String getValue() throws JAXRException {
        String value = this.getValue(Locale.getDefault());
        if (value == null) {
            value = this.getValue(new Locale(Locale.getDefault().getLanguage(), ""));
        }
        return value;
    }

    public String getValue(Locale locale) throws JAXRException {
        if (locale == null) {
            return null;
        }
        String key = this.makeKey(DEFAULT_CHARSET, locale);
        LocalizedString string = (LocalizedString)this.strings.get(key);
        return string == null ? null : string.getValue();
    }

    public void setValue(String string) throws JAXRException {
        this.setValue(Locale.getDefault(), string);
    }

    public void setValue(Locale locale, String string) throws JAXRException {
        String key = this.makeKey(DEFAULT_CHARSET, locale);
        this.strings.put(key, new LocalizedStringImpl(locale, string));
    }

    public void addLocalizedString(LocalizedString localizedString) throws JAXRException {
        if (localizedString == null) {
            throw new JAXRException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("InternationalStringImpl:LocalizedString_cannot_be_null"));
        }
        String key = this.makeKey(localizedString.getCharsetName(), localizedString.getLocale());
        this.strings.put(key, localizedString);
    }

    public void addLocalizedStrings(Collection strings) throws JAXRException {
        if (strings == null) {
            return;
        }
        Iterator iter = strings.iterator();
        try {
            while (iter.hasNext()) {
                this.addLocalizedString((LocalizedString)iter.next());
            }
        }
        catch (ClassCastException e) {
            throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("InternationalStringImpl:Objects_in_collection_must_be_LocalizedStrings"), (Throwable)e);
        }
    }

    public void removeLocalizedString(LocalizedString lString) throws JAXRException {
        if (lString == null) {
            return;
        }
        String key = this.makeKey(lString.getCharsetName(), lString.getLocale());
        this.strings.remove(key);
    }

    public void removeLocalizedStrings(Collection lStrings) throws JAXRException {
        if (lStrings == null) {
            return;
        }
        Iterator iter = lStrings.iterator();
        while (iter.hasNext()) {
            try {
                this.removeLocalizedString((LocalizedString)iter.next());
            }
            catch (ClassCastException e) {
                throw new UnexpectedObjectException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("InternationalStringImpl:Objects_in_collection_must_be_LocalizedStrings"), (Throwable)e);
            }
        }
    }

    public LocalizedString getLocalizedString(Locale locale, String charsetName) throws JAXRException {
        String key = this.makeKey(charsetName, locale);
        return (LocalizedString)this.strings.get(key);
    }

    public Collection getLocalizedStrings() throws JAXRException {
        return new ArrayList(this.strings.values());
    }

    private String makeKey(String charSet, Locale locale) {
        return new String(charSet + locale.toString());
    }
}

