/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.streaming;

import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.messaging.saaj.util.ByteOutputStream;
import com.sun.xml.rpc.sp.NamespaceSupport;
import com.sun.xml.rpc.streaming.Attributes;
import com.sun.xml.rpc.streaming.ElementIdStack;
import com.sun.xml.rpc.streaming.RecordedXMLReader;
import com.sun.xml.rpc.streaming.XMLReader;
import com.sun.xml.rpc.streaming.XMLReaderBase;
import com.sun.xml.rpc.streaming.XMLReaderException;
import com.sun.xml.rpc.util.exception.LocalizableExceptionAdapter;
import com.sun.xml.rpc.util.xml.XmlUtil;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.xml.sax.InputSource;

public class StAXReader
extends XMLReaderBase {
    static final String XMLNS_NAMESPACE_URI = "http://www.w3.org/2000/xmlns/";
    private XMLStreamReader reader;
    private int state;
    private static final int CONTINUE = -10;
    private static final int[] stax2XMLReader = new int[16];
    private QName currentName;
    private AttributesImpl currentAttributes;
    private ArrayList allPrefixes;
    private ElementIdStack elementIds;
    private int elementId;

    public StAXReader(InputSource source, boolean rejectDTDs) {
        try {
            this.reader = this.getInputFactory().createXMLStreamReader(source.getByteStream(), source.getEncoding());
            this.finishSetup();
        }
        catch (XMLStreamException e) {
            throw new XMLReaderException("staxreader.xmlstreamexception", new LocalizableExceptionAdapter(e));
        }
    }

    public StAXReader(InputSource source, boolean rejectDTDs, XMLStreamReader reader) {
        this.reader = reader;
        this.finishSetup();
    }

    public StAXReader(Source source, boolean rejectDTDs) {
        try {
            boolean workingYet = false;
            if (workingYet) {
                this.reader = this.getInputFactory().createXMLStreamReader(source);
            } else {
                Transformer transformer = XmlUtil.newTransformer();
                ByteOutputStream bos = new ByteOutputStream();
                transformer.transform(source, new StreamResult((OutputStream)bos));
                ByteInputStream istream = new ByteInputStream(bos.getBytes(), bos.getCount());
                InputSource iSource = new InputSource((InputStream)istream);
                this.reader = this.getInputFactory().createXMLStreamReader(iSource.getByteStream(), iSource.getEncoding());
            }
            this.finishSetup();
        }
        catch (XMLStreamException e) {
            throw new XMLReaderException("staxreader.xmlstreamexception", new LocalizableExceptionAdapter(e));
        }
        catch (TransformerException te) {
            throw new XMLReaderException("staxreader.xmlstreamexception", new LocalizableExceptionAdapter(te));
        }
    }

    public StAXReader(StringReader stringReader, boolean rejectDTDs) {
        try {
            this.reader = this.getInputFactory().createXMLStreamReader(stringReader);
            this.finishSetup();
        }
        catch (XMLStreamException e) {
            throw new XMLReaderException("staxreader.xmlstreamexception", new LocalizableExceptionAdapter(e));
        }
    }

    private XMLInputFactory getInputFactory() throws XMLStreamException {
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        inputFactory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        inputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        return inputFactory;
    }

    private void finishSetup() {
        this.state = stax2XMLReader[this.reader.getEventType()];
        this.allPrefixes = new ArrayList();
        this.elementIds = new ElementIdStack();
    }

    public XMLStreamReader getXMLStreamReader() {
        return this.reader;
    }

    public void synchronizeReader() {
        this.currentName = null;
        this.currentAttributes = null;
        this.state = stax2XMLReader[this.reader.getEventType()];
    }

    @Override
    public int next() {
        if (this.state == 5) {
            return 5;
        }
        this.currentName = null;
        this.currentAttributes = null;
        try {
            do {
                this.state = stax2XMLReader[this.reader.next()];
            } while (this.state == -10);
            if (this.state == 1) {
                this.collectPrefixes();
                this.elementId = this.elementIds.pushNext();
            } else if (this.state == 2) {
                this.elementId = this.elementIds.pop();
            }
        }
        catch (XMLStreamException e) {
            throw new XMLReaderException("staxreader.xmlstreamexception", new LocalizableExceptionAdapter(e));
        }
        return this.state;
    }

    @Override
    public int getState() {
        return this.state;
    }

    @Override
    public QName getName() {
        if (this.currentName == null) {
            this.currentName = this.reader.getName();
        }
        return this.currentName;
    }

    @Override
    public String getLocalName() {
        return this.reader.getLocalName();
    }

    @Override
    public String getURI() {
        return this.reader.getNamespaceURI();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Attributes getAttributes() {
        if (this.currentAttributes != null) return this.currentAttributes;
        if (this.reader.getEventType() != 1) {
            if (this.reader.getEventType() != 10) {
                this.currentAttributes = new AttributesImpl(null);
                return this.currentAttributes;
            }
        }
        this.currentAttributes = new AttributesImpl(this.reader);
        return this.currentAttributes;
    }

    @Override
    public String getURI(String prefix) {
        return this.reader.getNamespaceURI(prefix);
    }

    @Override
    public String getValue() {
        return this.reader.getText();
    }

    @Override
    public int getLineNumber() {
        return this.reader.getLocation().getLineNumber();
    }

    private void collectPrefixes() {
        for (int i = 0; i < this.reader.getNamespaceCount(); ++i) {
            String prefix = this.reader.getNamespacePrefix(i);
            if (prefix == null) continue;
            this.allPrefixes.add(prefix);
        }
    }

    @Override
    public Iterator getPrefixes() {
        Iterator iter = this.allPrefixes.iterator();
        HashSet<String> set = new HashSet<String>(this.allPrefixes.size());
        while (iter.hasNext()) {
            String prefix = (String)iter.next();
            if (this.reader.getNamespaceURI(prefix) == null) continue;
            set.add(prefix);
        }
        return set.iterator();
    }

    @Override
    public int getElementId() {
        return this.elementId;
    }

    @Override
    public void skipElement(int id) {
        while (this.state != 5 && (this.state != 2 || this.elementId != id)) {
            this.next();
        }
    }

    @Override
    public XMLReader recordElement() {
        return new RecordedXMLReader(this, new NamespaceContextWrapper(this.reader.getNamespaceContext()));
    }

    @Override
    public void close() {
        this.state = 5;
        try {
            this.reader.close();
        }
        catch (XMLStreamException e) {
            throw new XMLReaderException("staxreader.xmlstreamexception", new LocalizableExceptionAdapter(e));
        }
    }

    private void printStreamConstants() {
        System.out.println(" ");
        System.out.println("XMLStreamConstants.START_ELEMENT: 1");
        System.out.println("XMLStreamConstants.END_ELEMENT: 2");
        System.out.println("XMLStreamConstants.PROCESSING_INSTRUCTION: 3");
        System.out.println("XMLStreamConstants.CHARACTERS: 4");
        System.out.println("XMLStreamConstants.COMMENT: 5");
        System.out.println("XMLStreamConstants.SPACE: 6");
        System.out.println("XMLStreamConstants.START_DOCUMENT: 7");
        System.out.println("XMLStreamConstants.END_DOCUMENT: 8");
        System.out.println("XMLStreamConstants.ENTITY_REFERENCE: 9");
        System.out.println("XMLStreamConstants.ATTRIBUTE: 10");
        System.out.println("XMLStreamConstants.DTD: 11");
        System.out.println("XMLStreamConstants.CDATA: 12");
        System.out.println("XMLStreamConstants.NAMESPACE: 13");
        System.out.println("XMLStreamConstants.NOTATION_DECLARATION: 14");
        System.out.println("XMLStreamConstants.ENTITY_DECLARATION: 15");
    }

    static {
        for (int i = 0; i < 16; ++i) {
            StAXReader.stax2XMLReader[i] = -10;
        }
        StAXReader.stax2XMLReader[7] = 0;
        StAXReader.stax2XMLReader[1] = 1;
        StAXReader.stax2XMLReader[2] = 2;
        StAXReader.stax2XMLReader[4] = 3;
        StAXReader.stax2XMLReader[3] = 4;
        StAXReader.stax2XMLReader[8] = 5;
    }

    static class NamespaceContextWrapper
    extends NamespaceSupport {
        private NamespaceContext context;

        public NamespaceContextWrapper(NamespaceContext context) {
            this.context = context;
        }

        @Override
        public String getPrefix(String uri) {
            return this.context.getPrefix(uri);
        }

        @Override
        public String getURI(String prefix) {
            return this.context.getNamespaceURI(prefix);
        }

        @Override
        public Iterator getPrefixes(String uri) {
            return this.context.getPrefixes(uri);
        }

        @Override
        public Iterator getPrefixes() {
            throw new UnsupportedOperationException();
        }
    }

    static class AttributeInfo {
        private QName name;
        private String value;

        public AttributeInfo(QName name, String value) {
            this.name = name;
            this.value = value == null ? "" : value;
        }

        QName getName() {
            return this.name;
        }

        String getValue() {
            return this.value;
        }

        String getLocalName() {
            if (this.isNamespaceDeclaration()) {
                if (this.name.getLocalPart().equals("")) {
                    return "xmlns";
                }
                return "xmlns:" + this.name.getLocalPart();
            }
            return this.name.getLocalPart();
        }

        boolean isNamespaceDeclaration() {
            return this.name.getNamespaceURI() == StAXReader.XMLNS_NAMESPACE_URI;
        }
    }

    public static class AttributesImpl
    implements Attributes {
        AttributeInfo[] atInfos;

        public AttributesImpl(XMLStreamReader reader) {
            if (reader == null) {
                this.atInfos = new AttributeInfo[0];
            } else {
                int i;
                int index = 0;
                String namespacePrefix = null;
                int namespaceCount = reader.getNamespaceCount();
                int attributeCount = reader.getAttributeCount();
                this.atInfos = new AttributeInfo[namespaceCount + attributeCount];
                for (i = 0; i < namespaceCount; ++i) {
                    namespacePrefix = reader.getNamespacePrefix(i);
                    if (namespacePrefix == null) {
                        namespacePrefix = "";
                    }
                    this.atInfos[index++] = new AttributeInfo(new QName(StAXReader.XMLNS_NAMESPACE_URI, namespacePrefix, "xmlns"), reader.getNamespaceURI(i));
                }
                for (i = 0; i < attributeCount; ++i) {
                    this.atInfos[index++] = new AttributeInfo(reader.getAttributeName(i), reader.getAttributeValue(i));
                }
            }
        }

        @Override
        public int getLength() {
            return this.atInfos.length;
        }

        @Override
        public String getLocalName(int index) {
            if (index >= 0 && index < this.atInfos.length) {
                return this.atInfos[index].getLocalName();
            }
            return null;
        }

        @Override
        public QName getName(int index) {
            if (index >= 0 && index < this.atInfos.length) {
                return this.atInfos[index].getName();
            }
            return null;
        }

        @Override
        public String getPrefix(int index) {
            if (index >= 0 && index < this.atInfos.length) {
                return this.atInfos[index].getName().getPrefix();
            }
            return null;
        }

        @Override
        public String getURI(int index) {
            if (index >= 0 && index < this.atInfos.length) {
                return this.atInfos[index].getName().getNamespaceURI();
            }
            return null;
        }

        @Override
        public String getValue(int index) {
            if (index >= 0 && index < this.atInfos.length) {
                return this.atInfos[index].getValue();
            }
            return null;
        }

        @Override
        public String getValue(QName name) {
            int index = this.getIndex(name);
            if (index != -1) {
                return this.atInfos[index].getValue();
            }
            return null;
        }

        @Override
        public String getValue(String localName) {
            int index = this.getIndex(localName);
            if (index != -1) {
                return this.atInfos[index].getValue();
            }
            return null;
        }

        @Override
        public String getValue(String uri, String localName) {
            int index = this.getIndex(uri, localName);
            if (index != -1) {
                return this.atInfos[index].getValue();
            }
            return null;
        }

        @Override
        public boolean isNamespaceDeclaration(int index) {
            if (index >= 0 && index < this.atInfos.length) {
                return this.atInfos[index].isNamespaceDeclaration();
            }
            return false;
        }

        @Override
        public int getIndex(QName name) {
            for (int i = 0; i < this.atInfos.length; ++i) {
                if (!this.atInfos[i].getName().equals(name)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int getIndex(String localName) {
            for (int i = 0; i < this.atInfos.length; ++i) {
                if (!this.atInfos[i].getName().getLocalPart().equals(localName)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public int getIndex(String uri, String localName) {
            for (int i = 0; i < this.atInfos.length; ++i) {
                QName qName = this.atInfos[i].getName();
                if (!qName.getNamespaceURI().equals(uri) || !qName.getLocalPart().equals(localName)) continue;
                return i;
            }
            return -1;
        }
    }
}

