/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.runtime.util;

import com.sun.xml.ws.runtime.util.Session;
import com.sun.xml.ws.runtime.util.SessionManager;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextTokenInfo;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Set;
import javax.xml.ws.WebServiceException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionManagerImpl
extends SessionManager {
    private Hashtable<String, Session> sessionMap = new Hashtable();
    private Hashtable<String, IssuedTokenContext> issuedTokenContextMap = new Hashtable();

    @Override
    public Session getSession(String key) {
        return this.sessionMap.get(key);
    }

    @Override
    public Set<String> getKeys() {
        return this.sessionMap.keySet();
    }

    @Override
    public void terminateSession(String key) {
        this.sessionMap.remove(key);
    }

    @Override
    public Session createSession(String key, Class clasz) {
        Session sess;
        try {
            sess = new Session(this, key, clasz.newInstance());
        }
        catch (InstantiationException e) {
            return null;
        }
        catch (IllegalAccessException ee) {
            return null;
        }
        this.sessionMap.put(key, sess);
        return sess;
    }

    @Override
    public Session createSession(String key, Object obj) {
        Session sess = new Session(this, key, obj);
        this.sessionMap.put(key, sess);
        return sess;
    }

    @Override
    public Session createSession(String key) {
        return this.createSession(key, new Hashtable());
    }

    @Override
    public void saveSession(String key) {
    }

    @Override
    public IssuedTokenContext getSecurityContext(String key) {
        IssuedTokenContext ctx = this.issuedTokenContextMap.get(key);
        if (ctx == null) {
            Session session = this.getSessionManager().getSession(key);
            if (session != null) {
                SecurityContextTokenInfo sctInfo = session.getSecurityInfo();
                ctx = sctInfo.getIssuedTokenContext();
                this.getSessionManager().addSecurityContext(key, ctx);
            } else {
                throw new WebServiceException("Could not locate SecureConversation session for Id:" + key);
            }
        }
        if (ctx != null) {
            GregorianCalendar c = new GregorianCalendar();
            long offset = c.get(15);
            if (((Calendar)c).getTimeZone().inDaylightTime(c.getTime())) {
                offset += (long)((Calendar)c).getTimeZone().getDSTSavings();
            }
            long beforeTime = c.getTimeInMillis();
            long currentTime = beforeTime - offset;
            c.setTimeInMillis(currentTime);
            Date currentTimeInDateFormat = c.getTime();
            if (!currentTimeInDateFormat.after(ctx.getCreationTime()) || !currentTimeInDateFormat.before(ctx.getExpirationTime())) {
                throw new WebServiceException("SecureConversation session for session Id:" + key + "has expired.");
            }
        }
        return ctx;
    }

    @Override
    public void addSecurityContext(String key, IssuedTokenContext itctx) {
        this.issuedTokenContextMap.put(key, itctx);
    }
}

