/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.security.secconv;

import com.sun.xml.ws.api.security.trust.WSTrustException;
import com.sun.xml.ws.policy.AssertionSet;
import com.sun.xml.ws.policy.NestedPolicy;
import com.sun.xml.ws.policy.PolicyAssertion;
import com.sun.xml.ws.policy.impl.bindings.AppliesTo;
import com.sun.xml.ws.runtime.util.Session;
import com.sun.xml.ws.runtime.util.SessionManager;
import com.sun.xml.ws.security.IssuedTokenContext;
import com.sun.xml.ws.security.SecurityContextToken;
import com.sun.xml.ws.security.Token;
import com.sun.xml.ws.security.impl.policy.PolicyUtil;
import com.sun.xml.ws.security.impl.policy.Trust10;
import com.sun.xml.ws.security.impl.policy.Trust13;
import com.sun.xml.ws.security.policy.AlgorithmSuite;
import com.sun.xml.ws.security.policy.Binding;
import com.sun.xml.ws.security.policy.SecureConversationToken;
import com.sun.xml.ws.security.policy.SecurityPolicyVersion;
import com.sun.xml.ws.security.policy.SymmetricBinding;
import com.sun.xml.ws.security.secconv.WSSCElementFactory;
import com.sun.xml.ws.security.secconv.WSSCElementFactory13;
import com.sun.xml.ws.security.secconv.WSSCVersion;
import com.sun.xml.ws.security.secconv.WSSecureConversationException;
import com.sun.xml.ws.security.secconv.impl.SecurityContextTokenInfoImpl;
import com.sun.xml.ws.security.secconv.impl.wssx.WSSCVersion13;
import com.sun.xml.ws.security.secconv.logging.LogStringsMessages;
import com.sun.xml.ws.security.trust.Configuration;
import com.sun.xml.ws.security.trust.WSTrustVersion;
import com.sun.xml.ws.security.trust.elements.BaseSTSRequest;
import com.sun.xml.ws.security.trust.elements.BaseSTSResponse;
import com.sun.xml.ws.security.trust.elements.BinarySecret;
import com.sun.xml.ws.security.trust.elements.CancelTarget;
import com.sun.xml.ws.security.trust.elements.Entropy;
import com.sun.xml.ws.security.trust.elements.Lifetime;
import com.sun.xml.ws.security.trust.elements.RequestSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponse;
import com.sun.xml.ws.security.trust.elements.RequestSecurityTokenResponseCollection;
import com.sun.xml.ws.security.trust.elements.RequestedAttachedReference;
import com.sun.xml.ws.security.trust.elements.RequestedProofToken;
import com.sun.xml.ws.security.trust.elements.RequestedSecurityToken;
import com.sun.xml.ws.security.trust.elements.RequestedUnattachedReference;
import com.sun.xml.ws.security.trust.elements.str.DirectReference;
import com.sun.xml.ws.security.trust.elements.str.Reference;
import com.sun.xml.ws.security.trust.elements.str.SecurityTokenReference;
import com.sun.xml.ws.security.trust.impl.bindings.ObjectFactory;
import com.sun.xml.ws.security.trust.impl.bindings.RequestSecurityTokenResponseType;
import com.sun.xml.ws.security.trust.util.WSTrustUtil;
import com.sun.xml.ws.security.wsu10.AttributedDateTime;
import com.sun.xml.wss.impl.misc.SecurityUtil;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;

public class WSSCContract {
    private static final Logger log = Logger.getLogger("com.sun.xml.ws.security.secconv", "com.sun.xml.ws.security.secconv.logging.LogStrings");
    private long currentTime;
    private WSSCVersion wsscVer = WSSCVersion.WSSC_10;
    private WSTrustVersion wsTrustVer = WSTrustVersion.WS_TRUST_10;
    private static WSSCElementFactory eleFac = WSSCElementFactory.newInstance();
    private static WSSCElementFactory13 eleFac13 = WSSCElementFactory13.newInstance();
    private static final int DEFAULT_KEY_SIZE = 128;
    private static final long TIMEOUT = 36000000L;
    private static final SimpleDateFormat calendarFormatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'.'sss'Z'", Locale.getDefault());

    public WSSCContract() {
    }

    public WSSCContract(Configuration config, WSSCVersion wsscVer) {
        this.init(config, null);
    }

    public final void init(Configuration config, WSSCVersion wsscVer) {
        if (wsscVer instanceof WSSCVersion13) {
            this.wsscVer = wsscVer;
            this.wsTrustVer = WSTrustVersion.WS_TRUST_13;
        }
    }

    public BaseSTSResponse issue(BaseSTSRequest request, IssuedTokenContext context, SecureConversationToken scToken) throws WSSecureConversationException {
        URI tokenType = URI.create(this.wsscVer.getSCTTokenTypeURI());
        URI con = null;
        URI computeKeyAlgo = URI.create(this.wsTrustVer.getCKPSHA1algorithmURI());
        String conStr = ((RequestSecurityToken)request).getContext();
        if (conStr != null) {
            try {
                con = new URI(conStr);
            }
            catch (URISyntaxException ex) {
                log.log(Level.SEVERE, LogStringsMessages.WSSC_0008_URISYNTAX_EXCEPTION(((RequestSecurityToken)request).getContext()), ex);
                throw new WSSecureConversationException(LogStringsMessages.WSSC_0008_URISYNTAX_EXCEPTION(((RequestSecurityToken)request).getContext()), ex);
            }
        }
        AppliesTo scopes = ((RequestSecurityToken)request).getAppliesTo();
        RequestedProofToken proofToken = this.wsscVer.getNamespaceURI().equals(WSSCVersion.WSSC_13.getNamespaceURI()) ? eleFac13.createRequestedProofToken() : eleFac.createRequestedProofToken();
        byte[] clientEntr = null;
        Entropy clientEntropy = ((RequestSecurityToken)request).getEntropy();
        if (clientEntropy != null) {
            BinarySecret clientBS = clientEntropy.getBinarySecret();
            if (clientBS == null) {
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, LogStringsMessages.WSSC_0009_CLIENT_ENTROPY_VALUE("null"));
                }
            } else {
                clientEntr = clientBS.getRawValue();
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, LogStringsMessages.WSSC_0009_CLIENT_ENTROPY_VALUE(clientEntropy.toString()));
                }
            }
        }
        BaseSTSResponse response = this.createRSTR(computeKeyAlgo, scToken, request, scopes, clientEntr, proofToken, tokenType, clientEntropy, context, con);
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_0014_RSTR_RESPONSE(this.elemToString((RequestSecurityTokenResponse)response)));
        }
        return response;
    }

    private BaseSTSResponse createRSTR(URI computeKeyAlgo, SecureConversationToken scToken, BaseSTSRequest request, AppliesTo scopes, byte[] clientEntr, RequestedProofToken proofToken, URI tokenType, Entropy clientEntropy, IssuedTokenContext context, URI con) throws WSSecureConversationException, WSSecureConversationException {
        int keySize;
        Set trustReqdProps;
        Trust10 trust10 = null;
        Trust13 trust13 = null;
        Binding symBinding = null;
        NestedPolicy wsPolicy = scToken.getBootstrapPolicy();
        AssertionSet assertionSet = wsPolicy.getAssertionSet();
        for (PolicyAssertion policyAssertion : assertionSet) {
            SecurityPolicyVersion spVersion;
            if (PolicyUtil.isTrust13(policyAssertion, spVersion = this.getSPVersion(policyAssertion))) {
                trust13 = (Trust13)policyAssertion;
                continue;
            }
            if (PolicyUtil.isTrust10(policyAssertion, spVersion)) {
                trust10 = (Trust10)policyAssertion;
                continue;
            }
            if (!PolicyUtil.isSymmetricBinding(policyAssertion, spVersion)) continue;
            symBinding = (SymmetricBinding)((Object)policyAssertion);
        }
        boolean reqServerEntr = true;
        boolean reqClientEntr = false;
        if (trust10 != null) {
            trustReqdProps = trust10.getRequiredProperties();
            reqServerEntr = trustReqdProps.contains("RequireServerEntropy");
            reqClientEntr = trustReqdProps.contains("RequireClientEntropy");
        }
        if (trust13 != null) {
            trustReqdProps = trust13.getRequiredProperties();
            reqServerEntr = trustReqdProps.contains("RequireServerEntropy");
            reqClientEntr = trustReqdProps.contains("RequireClientEntropy");
        }
        if (clientEntropy == null) {
            if (reqClientEntr) {
                log.log(Level.SEVERE, LogStringsMessages.WSSC_0010_CLIENT_ENTROPY_CANNOT_NULL());
                throw new WSSecureConversationException(LogStringsMessages.WSSC_0010_CLIENT_ENTROPY_CANNOT_NULL());
            }
            reqServerEntr = true;
        }
        if ((keySize = (int)((RequestSecurityToken)request).getKeySize()) < 1 && symBinding != null) {
            AlgorithmSuite algoSuite = symBinding.getAlgorithmSuite();
            keySize = algoSuite.getMinSKLAlgorithm();
        }
        if (keySize < 1) {
            keySize = 128;
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_0011_KEY_SIZE_VALUE(keySize, 128));
        }
        byte[] secret = WSTrustUtil.generateRandomSecret(keySize / 8);
        String proofTokenType = clientEntr == null || clientEntr.length == 0 ? this.wsTrustVer.getSymmetricKeyTypeURI() : this.wsTrustVer.getNonceBinarySecretTypeURI();
        Entropy serverEntropy = null;
        if (reqServerEntr) {
            BinarySecret serverBS = this.wsscVer.getNamespaceURI().equals(WSSCVersion.WSSC_13.getNamespaceURI()) ? eleFac13.createBinarySecret(secret, proofTokenType) : eleFac.createBinarySecret(secret, proofTokenType);
            if (proofTokenType.equals(this.wsTrustVer.getNonceBinarySecretTypeURI())) {
                serverEntropy = this.wsscVer.getNamespaceURI().equals(WSSCVersion.WSSC_13.getNamespaceURI()) ? eleFac13.createEntropy(serverBS) : eleFac.createEntropy(serverBS);
                proofToken.setProofTokenType("ComputedKey");
                proofToken.setComputedKey(computeKeyAlgo);
                try {
                    secret = SecurityUtil.P_SHA1((byte[])clientEntr, (byte[])secret, (int)(keySize / 8));
                }
                catch (Exception ex) {
                    log.log(Level.SEVERE, LogStringsMessages.WSSC_0012_COMPUTE_SECKEY(), ex);
                    throw new WSSecureConversationException(LogStringsMessages.WSSC_0012_COMPUTE_SECKEY(), ex);
                }
            } else {
                proofToken.setProofTokenType("BinarySecret");
                proofToken.setBinarySecret(serverBS);
            }
        } else if (clientEntropy != null) {
            secret = clientEntr;
            proofToken.setProofTokenType("BinarySecret");
            proofToken.setBinarySecret(clientEntropy.getBinarySecret());
        }
        if (this.wsscVer.getNamespaceURI().equals(WSSCVersion.WSSC_13.getNamespaceURI())) {
            return this.createResponseFor13NS(serverEntropy, con, scopes, secret, proofToken, context, tokenType);
        }
        return this.createResponse(serverEntropy, con, scopes, secret, proofToken, context, tokenType);
    }

    private BaseSTSResponse createResponse(Entropy serverEntropy, URI con, AppliesTo scopes, byte[] secret, RequestedProofToken proofToken, IssuedTokenContext context, URI tokenType) throws WSSecureConversationException {
        SecurityContextToken token = WSTrustUtil.createSecurityContextToken(eleFac);
        RequestedSecurityToken rst = eleFac.createRequestedSecurityToken((Token)token);
        SecurityTokenReference attachedReference = this.createSecurityTokenReference(token.getWsuId(), false);
        RequestedAttachedReference rar = eleFac.createRequestedAttachedReference(attachedReference);
        SecurityTokenReference unattachedRef = this.createSecurityTokenReference(token.getIdentifier().toString(), true);
        RequestedUnattachedReference rur = eleFac.createRequestedUnattachedReference(unattachedRef);
        Lifetime lifetime = this.createLifetime();
        RequestSecurityTokenResponse response = null;
        try {
            response = eleFac.createRSTRForIssue(tokenType, con, rst, scopes, rar, rur, proofToken, serverEntropy, lifetime);
        }
        catch (WSTrustException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0020_PROBLEM_CREATING_RSTR(), ex);
            throw new WSSecureConversationException(LogStringsMessages.WSSC_0020_PROBLEM_CREATING_RSTR(), ex);
        }
        Session session = SessionManager.getSessionManager().createSession(token.getIdentifier().toString());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_1010_CREATING_SESSION(token.getIdentifier()));
        }
        this.populateITC(session, secret, token, attachedReference, context, unattachedRef);
        SessionManager.getSessionManager().addSecurityContext(token.getIdentifier().toString(), context);
        return response;
    }

    private BaseSTSResponse createResponseFor13NS(Entropy serverEntropy, URI con, AppliesTo scopes, byte[] secret, RequestedProofToken proofToken, IssuedTokenContext context, URI tokenType) throws WSSecureConversationException {
        SecurityContextToken token = WSTrustUtil.createSecurityContextToken(eleFac13);
        RequestedSecurityToken rst = eleFac13.createRequestedSecurityToken((Token)token);
        SecurityTokenReference attachedReference = this.createSecurityTokenReference(token.getWsuId(), false);
        RequestedAttachedReference rar = eleFac13.createRequestedAttachedReference(attachedReference);
        SecurityTokenReference unattachedRef = this.createSecurityTokenReference(token.getIdentifier().toString(), true);
        RequestedUnattachedReference rur = eleFac13.createRequestedUnattachedReference(unattachedRef);
        Lifetime lifetime = this.createLifetime();
        RequestSecurityTokenResponseCollection response = null;
        try {
            response = eleFac13.createRSTRCollectionForIssue(tokenType, con, rst, scopes, rar, rur, proofToken, serverEntropy, lifetime);
        }
        catch (WSTrustException ex) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0020_PROBLEM_CREATING_RSTR(), ex);
            throw new WSSecureConversationException(LogStringsMessages.WSSC_0020_PROBLEM_CREATING_RSTR(), ex);
        }
        Session session = SessionManager.getSessionManager().createSession(token.getIdentifier().toString());
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_1010_CREATING_SESSION(token.getIdentifier()));
        }
        this.populateITC(session, secret, token, attachedReference, context, unattachedRef);
        SessionManager.getSessionManager().addSecurityContext(token.getIdentifier().toString(), context);
        return response;
    }

    private void populateITC(Session session, byte[] secret, SecurityContextToken token, SecurityTokenReference attachedReference, IssuedTokenContext context, SecurityTokenReference unattachedRef) {
        context.setSecurityToken((Token)token);
        context.setAttachedSecurityTokenReference((Token)attachedReference);
        context.setUnAttachedSecurityTokenReference((Token)unattachedRef);
        context.setProofKey(secret);
        context.setCreationTime(new Date(this.currentTime));
        context.setExpirationTime(new Date(this.currentTime + 36000000L));
        SecurityContextTokenInfoImpl sctinfo = new SecurityContextTokenInfoImpl();
        sctinfo.setIdentifier(token.getIdentifier().toString());
        sctinfo.setExternalId(token.getWsuId());
        sctinfo.addInstance(null, secret);
        sctinfo.setCreationTime(new Date(this.currentTime));
        sctinfo.setExpirationTime(new Date(this.currentTime + 36000000L));
        session.setSecurityInfo(sctinfo);
    }

    public RequestSecurityTokenResponseCollection issueMultiple(RequestSecurityToken request, IssuedTokenContext context) throws WSSecureConversationException {
        return null;
    }

    public RequestSecurityTokenResponse renew(RequestSecurityToken request, IssuedTokenContext context) throws WSSecureConversationException {
        return null;
    }

    public BaseSTSResponse cancel(BaseSTSRequest request, IssuedTokenContext context) throws WSSecureConversationException {
        BaseSTSResponse rstr;
        IssuedTokenContext cxt;
        CancelTarget cancelTgt = ((RequestSecurityToken)request).getCancelTarget();
        SecurityTokenReference str = cancelTgt.getSecurityTokenReference();
        String id = null;
        Reference ref = str.getReference();
        if (ref.getType().equals("Reference")) {
            id = ((DirectReference)ref).getURIAttr().toString();
        }
        if ((cxt = SessionManager.getSessionManager().getSecurityContext(id)) == null || cxt.getSecurityToken() == null) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0015_UNKNOWN_CONTEXT(id));
            throw new WSSecureConversationException(LogStringsMessages.WSSC_0015_UNKNOWN_CONTEXT(id));
        }
        if (this.wsscVer.getNamespaceURI().equals(WSSCVersion.WSSC_13.getNamespaceURI())) {
            RequestSecurityTokenResponse resp = eleFac13.createRSTRForCancel();
            ArrayList<RequestSecurityTokenResponse> list = new ArrayList<RequestSecurityTokenResponse>();
            list.add(resp);
            try {
                rstr = eleFac13.createRSTRCollectionForIssue(list);
            }
            catch (WSTrustException ex) {
                throw new WSSecureConversationException(ex);
            }
        } else {
            rstr = eleFac.createRSTRForCancel();
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, LogStringsMessages.WSSC_0014_RSTR_RESPONSE(this.elemToString((RequestSecurityTokenResponse)rstr)));
        }
        return rstr;
    }

    public RequestSecurityTokenResponse validate(RequestSecurityToken request, IssuedTokenContext context) throws WSSecureConversationException {
        return null;
    }

    public void handleUnsolicited(RequestSecurityTokenResponse rstr, IssuedTokenContext context) throws WSSecureConversationException {
        RequestedSecurityToken rqSecToken = rstr.getRequestedSecurityToken();
        Token token = rqSecToken.getToken();
        RequestedProofToken rqProofToken = rstr.getRequestedProofToken();
        String proofTokenType = rqProofToken.getProofTokenType();
        if (proofTokenType.equals("BinarySecret")) {
            BinarySecret binarySecret = rqProofToken.getBinarySecret();
            if (binarySecret.getType().equals(this.wsTrustVer.getSymmetricKeyTypeURI())) {
                byte[] secret = binarySecret.getRawValue();
                context.setProofKey(secret);
            }
        } else if (proofTokenType.equals("EncryptedKey")) {
            // empty if block
        }
        context.setSecurityToken(token);
        long curTime = System.currentTimeMillis();
        Date creationTime = new Date(curTime);
        Date expirationTime = new Date(curTime + 36000000L);
        context.setCreationTime(creationTime);
        context.setExpirationTime(expirationTime);
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, LogStringsMessages.WSSC_1003_SETTING_TIMES(creationTime.toString(), expirationTime.toString()));
        }
    }

    private SecurityTokenReference createSecurityTokenReference(String id, boolean unattached) {
        String uri;
        String string = uri = unattached ? id : "#" + id;
        if (this.wsscVer.getNamespaceURI().equals(WSSCVersion.WSSC_13.getNamespaceURI())) {
            DirectReference ref = eleFac13.createDirectReference(this.wsscVer.getSCTTokenTypeURI(), uri);
            return eleFac13.createSecurityTokenReference(ref);
        }
        DirectReference ref = eleFac.createDirectReference(this.wsscVer.getSCTTokenTypeURI(), uri);
        return eleFac.createSecurityTokenReference(ref);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Lifetime createLifetime() {
        GregorianCalendar cal = new GregorianCalendar();
        int offset = cal.get(15);
        if (((Calendar)cal).getTimeZone().inDaylightTime(cal.getTime())) {
            offset += ((Calendar)cal).getTimeZone().getDSTSavings();
        }
        SimpleDateFormat simpleDateFormat = calendarFormatter;
        synchronized (simpleDateFormat) {
            calendarFormatter.setTimeZone(((Calendar)cal).getTimeZone());
            long beforeTime = cal.getTimeInMillis();
            this.currentTime = beforeTime - (long)offset;
            cal.setTimeInMillis(this.currentTime);
            AttributedDateTime created = new AttributedDateTime();
            created.setValue(calendarFormatter.format(cal.getTime()));
            AttributedDateTime expires = new AttributedDateTime();
            cal.setTimeInMillis(this.currentTime + 36000000L);
            expires.setValue(calendarFormatter.format(cal.getTime()));
            Lifetime lifetime = this.wsscVer.getNamespaceURI().equals(WSSCVersion.WSSC_13.getNamespaceURI()) ? eleFac13.createLifetime(created, expires) : eleFac.createLifetime(created, expires);
            return lifetime;
        }
    }

    private String elemToString(RequestSecurityTokenResponse rstr) {
        try {
            Marshaller marshaller = this.wsscVer.getNamespaceURI().equals(WSSCVersion.WSSC_13.getNamespaceURI()) ? eleFac13.getContext().createMarshaller() : eleFac.getContext().createMarshaller();
            JAXBElement rstrElement = new ObjectFactory().createRequestSecurityTokenResponse((RequestSecurityTokenResponseType)rstr);
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            StringWriter writer = new StringWriter();
            marshaller.marshal((Object)rstrElement, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, LogStringsMessages.WSSC_0001_ERROR_MARSHAL_LOG());
            throw new RuntimeException(LogStringsMessages.WSSC_0001_ERROR_MARSHAL_LOG(), e);
        }
    }

    private SecurityPolicyVersion getSPVersion(PolicyAssertion pa) {
        String nsUri = pa.getName().getNamespaceURI();
        SecurityPolicyVersion spVersion = SecurityPolicyVersion.SECURITYPOLICY200507;
        if (SecurityPolicyVersion.SECURITYPOLICY12NS.namespaceUri.equals(nsUri)) {
            spVersion = SecurityPolicyVersion.SECURITYPOLICY12NS;
        }
        return spVersion;
    }
}

