/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.assembler;

import com.sun.istack.NotNull;
import com.sun.xml.ws.api.BindingID;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.ServerTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Tube;
import com.sun.xml.ws.api.pipe.TubelineAssembler;
import com.sun.xml.ws.api.pipe.TubelineAssemblerFactory;
import com.sun.xml.ws.api.server.SDDocumentFilter;
import com.sun.xml.ws.api.server.ServiceDefinition;
import com.sun.xml.ws.assembler.TubeAppender;
import com.sun.xml.ws.assembler.TubelineAssemblyContextUpdater;
import com.sun.xml.ws.assembler.TubelineAssemblyController;
import com.sun.xml.ws.assembler.WsitClientTubeAssemblyContext;
import com.sun.xml.ws.assembler.WsitServerTubeAssemblyContext;
import com.sun.xml.ws.policy.jaxws.xmlstreamwriter.documentfilter.WsdlDocumentFilter;
import java.util.Collection;

public final class TubelineAssemblerFactoryImpl
extends TubelineAssemblerFactory {
    public TubelineAssembler doCreate(BindingID bindingId) {
        return new WsitTubelineAssembler(bindingId);
    }

    private static class WsitTubelineAssembler
    implements TubelineAssembler {
        private final BindingID bindingId;
        private final TubelineAssemblyController tubelineAssemblyController;

        WsitTubelineAssembler(BindingID bindingId) {
            this.bindingId = bindingId;
            this.tubelineAssemblyController = new TubelineAssemblyController();
        }

        @NotNull
        public Tube createClient(@NotNull ClientTubeAssemblerContext context) {
            WsitClientTubeAssemblyContext wsitContext = new WsitClientTubeAssemblyContext(context);
            Collection<TubeAppender> appenders = this.tubelineAssemblyController.getClientSideAppenders();
            for (TubeAppender appender : appenders) {
                if (!(appender instanceof TubelineAssemblyContextUpdater)) continue;
                ((TubelineAssemblyContextUpdater)((Object)appender)).prepareContext(wsitContext);
            }
            for (TubeAppender appender : appenders) {
                wsitContext.setTubelineHead(appender.appendTube(wsitContext));
            }
            return wsitContext.getTubelineHead();
        }

        @NotNull
        public Tube createServer(@NotNull ServerTubeAssemblerContext context) {
            WsitServerTubeAssemblyContext wsitContext = new WsitServerTubeAssemblyContext(context);
            ServiceDefinition sd = wsitContext.getEndpoint().getServiceDefinition();
            if (sd != null) {
                sd.addFilter((SDDocumentFilter)new WsdlDocumentFilter());
            }
            Collection<TubeAppender> appenders = this.tubelineAssemblyController.getServerSideAppenders();
            for (TubeAppender appender : appenders) {
                if (!(appender instanceof TubelineAssemblyContextUpdater)) continue;
                ((TubelineAssemblyContextUpdater)((Object)appender)).prepareContext(wsitContext);
            }
            for (TubeAppender appender : appenders) {
                wsitContext.setTubelineHead(appender.appendTube(wsitContext));
            }
            return wsitContext.getTubelineHead();
        }
    }
}

