/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.assembler;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.xml.ws.api.EndpointAddress;
import com.sun.xml.ws.api.WSBinding;
import com.sun.xml.ws.api.WSService;
import com.sun.xml.ws.api.client.WSPortInfo;
import com.sun.xml.ws.api.model.SEIModel;
import com.sun.xml.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.ws.api.model.wsdl.WSDLService;
import com.sun.xml.ws.api.pipe.ClientTubeAssemblerContext;
import com.sun.xml.ws.api.pipe.Codec;
import com.sun.xml.ws.api.server.Container;
import com.sun.xml.ws.assembler.WsitTubeAssemblyContext;
import com.sun.xml.ws.policy.PolicyMap;
import com.sun.xml.ws.policy.jaxws.WSDLPolicyMapWrapper;
import com.sun.xml.ws.policy.jaxws.client.PolicyFeature;
import com.sun.xml.ws.security.secconv.SecureConversationInitiator;

public class WsitClientTubeAssemblyContext
extends WsitTubeAssemblyContext {
    @NotNull
    private final ClientTubeAssemblerContext wrappedContext;
    private final PolicyMap policyMap;
    private final WSPortInfo portInfo;
    private final WSDLPort wsdlPort;
    private SecureConversationInitiator scInitiator;

    public WsitClientTubeAssemblyContext(@NotNull ClientTubeAssemblerContext context) {
        this.wrappedContext = context;
        WSDLPort _port = context.getWsdlModel();
        WSPortInfo _portInfo = null;
        PolicyMap _policyMap = null;
        if (_port != null) {
            WSDLPolicyMapWrapper mapWrapper = (WSDLPolicyMapWrapper)_port.getBinding().getOwner().getExtension(WSDLPolicyMapWrapper.class);
            if (mapWrapper != null) {
                _policyMap = mapWrapper.getPolicyMap();
            }
        } else {
            PolicyFeature feature = (PolicyFeature)context.getBinding().getFeature(PolicyFeature.class);
            if (feature != null) {
                WSDLService service;
                _policyMap = feature.getPolicyMap();
                _portInfo = feature.getPortInfo();
                if (_portInfo != null && feature.getWsdlModel() != null && (service = feature.getWsdlModel().getService(_portInfo.getServiceName())) != null) {
                    _port = service.get(_portInfo.getPortName());
                }
            }
        }
        this.wsdlPort = _port;
        this.portInfo = _portInfo;
        this.policyMap = _policyMap;
    }

    public PolicyMap getPolicyMap() {
        return this.policyMap;
    }

    public boolean isPolicyAvailable() {
        return this.policyMap != null && !this.policyMap.isEmpty();
    }

    public WSDLPort getWsdlPort() {
        return this.wsdlPort;
    }

    public WSPortInfo getPortInfo() {
        return this.portInfo;
    }

    @NotNull
    public EndpointAddress getAddress() {
        return this.wrappedContext.getAddress();
    }

    @NotNull
    public WSService getService() {
        return this.wrappedContext.getService();
    }

    @NotNull
    public WSBinding getBinding() {
        return this.wrappedContext.getBinding();
    }

    @Nullable
    public SEIModel getSEIModel() {
        return this.wrappedContext.getSEIModel();
    }

    public Container getContainer() {
        return this.wrappedContext.getContainer();
    }

    @NotNull
    public Codec getCodec() {
        return this.wrappedContext.getCodec();
    }

    public void setCodec(@NotNull Codec codec) {
        this.wrappedContext.setCodec(codec);
    }

    public SecureConversationInitiator getScInitiator() {
        return this.scInitiator;
    }

    public void setScInitiator(SecureConversationInitiator initiator) {
        this.scInitiator = initiator;
    }

    public ClientTubeAssemblerContext getWrappedContext() {
        return this.wrappedContext;
    }
}

